/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service;

import java.util.List;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.connector.MapdustConnector;
import org.openstreetmap.josm.plugins.mapdust.service.connector.MapdustConnectorException;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustGetBugResponse;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustGetBugsResponse;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustPostResponse;
import org.openstreetmap.josm.plugins.mapdust.service.converter.MapdustConverter;
import org.openstreetmap.josm.plugins.mapdust.service.value.BoundingBox;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.plugins.mapdust.service.value.Paging;

public class MapdustServiceHandler {
    private final MapdustConnector connector;

    public MapdustServiceHandler() {
        this.connector = new MapdustConnector();
    }

    public MapdustServiceHandler(MapdustConnector connector) {
        this.connector = connector;
    }

    public List<MapdustBug> getBugs(BoundingBox bBox, MapdustBugFilter filter) throws MapdustServiceHandlerException {
        MapdustGetBugsResponse getBugsResponse = null;
        if (bBox.getMinLon() == null || bBox.getMinLat() == null || bBox.getMaxLon() == null || bBox.getMaxLat() == null) {
            throw new MapdustServiceHandlerException("Invalid coordinates!");
        }
        try {
            getBugsResponse = this.connector.getBugs(bBox, filter);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustServiceHandlerException(e.getMessage(), e);
        }
        List<MapdustBug> bugsList = MapdustConverter.buildMapdustBugList(getBugsResponse);
        return bugsList;
    }

    public MapdustBug getBug(Long id, Paging paging) throws MapdustServiceHandlerException {
        MapdustGetBugResponse getBugResponse = null;
        if (id == null) {
            String errorMessage = "Invalid id. The id cannot be null!";
            throw new MapdustServiceHandlerException(errorMessage);
        }
        try {
            getBugResponse = this.connector.getBug(id, paging);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustServiceHandlerException(e.getMessage(), e);
        }
        MapdustBug bug = MapdustConverter.buildMapdustBug(getBugResponse);
        return bug;
    }

    public Long addBug(MapdustBug bug) throws MapdustServiceHandlerException {
        MapdustPostResponse postResponse = null;
        if (bug == null) {
            String errorMessage = "Invalid bug. The bug cannot be null!";
            throw new MapdustServiceHandlerException(errorMessage);
        }
        try {
            postResponse = this.connector.addBug(bug);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustServiceHandlerException(e.getMessage(), e);
        }
        Long id = null;
        if (postResponse != null) {
            id = postResponse.getId();
        }
        return id;
    }

    public Long commentBug(MapdustComment comment) throws MapdustServiceHandlerException {
        MapdustPostResponse postResponse = null;
        if (comment == null) {
            String errorMessage = "Invalid comment. The comment cannot be null!";
            throw new MapdustServiceHandlerException(errorMessage);
        }
        try {
            postResponse = this.connector.commentBug(comment);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustServiceHandlerException(e.getMessage(), e);
        }
        Long id = null;
        if (postResponse != null) {
            id = postResponse.getId();
        }
        return id;
    }

    public Long changeBugStatus(Integer statusId, MapdustComment comment) throws MapdustServiceHandlerException {
        MapdustPostResponse postResponse = null;
        if (statusId == null) {
            String errorMessage = "Invalid status id. The status id cannot ";
            errorMessage = errorMessage + "be null!";
            throw new MapdustServiceHandlerException(errorMessage);
        }
        if (comment == null) {
            String errorMessage = "Invalid comment. The comment cannot be null!";
            throw new MapdustServiceHandlerException(errorMessage);
        }
        try {
            postResponse = this.connector.changeBugStatus(statusId, comment);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustServiceHandlerException(e.getMessage(), e);
        }
        Long id = null;
        if (postResponse != null) {
            id = postResponse.getId();
        }
        return id;
    }
}

