/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.widgets.HistoryChangedListener;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.api.EditAction;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.dialogs.TextInputDialog;
import org.openstreetmap.josm.tools.I18n;

public class AddCommentAction
extends OsbAction {
    private static final long serialVersionUID = 1L;
    private EditAction editAction = new EditAction();
    private String comment;
    private Node node;

    public AddCommentAction(OsbDialog dialog) {
        super(I18n.tr((String)"Add a comment", (Object[])new Object[0]), dialog);
    }

    protected void doActionPerformed(ActionEvent e) throws Exception {
        LinkedList<String> history = new LinkedList<String>(Main.pref.getCollection("osb.comment.history", new LinkedList()));
        HistoryChangedListener l = new HistoryChangedListener(){

            public void historyChanged(List<String> history) {
                Main.pref.putCollection("osb.comment.history", history);
            }
        };
        this.node = this.dialog.getSelectedNode();
        this.comment = TextInputDialog.showDialog((JComponent)Main.map, I18n.tr((String)"Add a comment", (Object[])new Object[0]), I18n.tr((String)"Enter your comment", (Object[])new Object[0]), OsbPlugin.loadIcon("add_comment22.png"), history, l);
        if (this.comment == null) {
            this.canceled = true;
        }
    }

    public void execute() throws IOException {
        this.comment = this.addMesgInfo(this.comment);
        this.editAction.execute(this.node, this.comment);
    }

    public String toString() {
        return I18n.tr((String)("Comment: " + this.node.get("note") + " - " + this.comment), (Object[])new Object[0]);
    }

    public AddCommentAction clone() {
        AddCommentAction action = new AddCommentAction(this.dialog);
        action.comment = this.comment;
        action.canceled = this.canceled;
        action.node = this.node;
        return action;
    }
}

