/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.util;

import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerPlugin;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationProducer {
    private JunctionCheckerPlugin plugin;
    private HashSet<HashSet<Channel>> storedRelations;

    public RelationProducer(JunctionCheckerPlugin plugin) {
        this.plugin = plugin;
        this.storedRelations = new HashSet();
    }

    public void produceRelation(HashSet<Channel> subset, int n) {
        if (this.isProduced(subset)) {
            return;
        }
        LinkedList<OsmPrimitive> ways = new LinkedList<OsmPrimitive>();
        for (Channel c : subset) {
            if (ways.contains(this.plugin.getOsmlayer().data.getPrimitiveById(c.getWay().getId(), OsmPrimitiveType.WAY))) continue;
            ways.add(this.plugin.getOsmlayer().data.getPrimitiveById(c.getWay().getId(), OsmPrimitiveType.WAY));
        }
        Main.map.mapView.setActiveLayer((Layer)this.plugin.getOsmlayer());
        this.plugin.getOsmlayer().data.setSelected(ways);
        Relation jrelation = new Relation();
        jrelation.put("type", "junction");
        jrelation.put("n", Integer.toString(n));
        for (int i = 0; i < ways.size(); ++i) {
            jrelation.addMember(new RelationMember("part of", (OsmPrimitive)ways.get(i)));
        }
        this.plugin.getOsmlayer().data.addPrimitive((OsmPrimitive)jrelation);
    }

    private boolean isProduced(HashSet<Channel> subset) {
        if (this.storedRelations.contains(subset)) {
            return true;
        }
        this.storedRelations.add(subset);
        return false;
    }
}

