/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.connectedness;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrongConnectednessCalculator {
    private int index = 0;
    private final ArrayList<Channel> stack = new ArrayList();
    private final ArrayList<ArrayList<Channel>> SCC = new ArrayList();
    private final int numberOfNodes;
    private int calculatedNodes = 0;
    private ArrayList<Channel> nsccchannels = new ArrayList();
    private final ChannelDiGraph digraph;
    int biggestPart = 0;

    public StrongConnectednessCalculator(ChannelDiGraph digraph) {
        this.digraph = digraph;
        this.numberOfNodes = digraph.numberOfChannels();
    }

    private int findUncalculatedNodes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            if (this.digraph.getChannelAtPosition(i).getLowlink() != -1) continue;
            return i;
        }
        return 0;
    }

    public void calculateSCC() {
        while (this.calculatedNodes != this.numberOfNodes) {
            this.tarjan(this.digraph.getChannelAtPosition(this.findUncalculatedNodes()));
        }
        for (int i = 0; i < this.SCC.size(); ++i) {
        }
        this.findBiggestPiece();
        this.saveNotSCCChannel();
    }

    private void saveNotSCCChannel() {
        int i;
        this.nsccchannels = new ArrayList();
        for (i = 0; i < this.SCC.size(); ++i) {
            if (i == this.biggestPart) continue;
            this.nsccchannels.addAll((Collection<Channel>)this.SCC.get(i));
        }
        for (i = 0; i < this.nsccchannels.size(); ++i) {
            this.nsccchannels.get(i).setStrongConnected(false);
        }
    }

    private void findBiggestPiece() {
        int number = 0;
        for (int i = 0; i < this.SCC.size(); ++i) {
            if (this.SCC.get(i).size() <= number) continue;
            this.biggestPart = i;
            number = this.SCC.get(i).size();
        }
    }

    public String showNotstronglyConnectednessParts() {
        String s = new String();
        for (int i = 0; i < this.SCC.size(); ++i) {
            if (i == this.biggestPart) continue;
            s = s + "GraphKomponente: " + i + "\n";
            for (int j = 0; j < this.SCC.get(i).size(); ++j) {
                s = s + "Channel: " + this.SCC.get(i).get(j).getNewid();
            }
            s = s + "\n";
        }
        return s;
    }

    public ArrayList<Channel> getNotConnectedChannels() {
        return this.nsccchannels;
    }

    private void tarjan(Channel v) {
        v.setIndex(this.index);
        v.setLowlink(this.index);
        ++this.index;
        this.stack.add(0, v);
        for (int i = 0; i < v.getLeadsTo().size(); ++i) {
            Channel n = v.getLeadsTo().get(i).getToChannel();
            if (n.getIndex() == -1) {
                this.tarjan(n);
                v.setLowlink(Math.min(v.getLowlink(), n.getLowlink()));
                continue;
            }
            if (!this.stack.contains(n)) continue;
            v.setLowlink(Math.min(v.getLowlink(), n.getLowlink()));
        }
        if (v.getLowlink() == v.getIndex()) {
            Channel n;
            ArrayList<Channel> component = new ArrayList<Channel>();
            do {
                n = this.stack.remove(0);
                component.add(n);
            } while (n != v);
            this.SCC.add(component);
            this.calculatedNodes += component.size();
        }
    }
}

