/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreInterface;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.GeorefImage;
import cadastre_fr.ImageModifier;
import cadastre_fr.RasterImageModifier;
import cadastre_fr.VectorImageModifier;
import cadastre_fr.WMSLayer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public class CadastreGrabber {
    private CadastreInterface wmsInterface = new CadastreInterface();

    public GeorefImage grab(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws IOException, OsmTransferException {
        try {
            URL url = null;
            url = wmsLayer.isRaster() ? this.getURLRaster(wmsLayer, lambertMin, lambertMax) : this.getURLVector(lambertMin, lambertMax);
            BufferedImage img = this.grab(url);
            ImageModifier imageModified = wmsLayer.isRaster() ? new RasterImageModifier(img) : new VectorImageModifier(img, false);
            return new GeorefImage(imageModified.bufferedImage, lambertMin, lambertMax, wmsLayer);
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.", (Object[])new Object[0])).initCause(e);
        }
    }

    private URL getURLRaster(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        int cRasterX = CadastrePlugin.imageWidth;
        String str = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        str = str + "&layers=CDIF:PMC@";
        str = str + wmsLayer.getCodeCommune();
        str = str + "&format=image/png";
        str = str + "&bbox=";
        str = str + wmsLayer.eastNorth2raster(lambertMin, lambertMax);
        str = str + "&width=" + cRasterX + "&height=";
        str = str + (int)((double)cRasterX * (wmsLayer.communeBBox.max.getY() - wmsLayer.communeBBox.min.getY()) / (wmsLayer.communeBBox.max.getX() - wmsLayer.communeBBox.min.getX()));
        str = str + "&exception=application/vnd.ogc.se_inimage&styles=";
        System.out.println("URL=" + str);
        return new URL(str.replace(" ", "%20"));
    }

    private URL buildURLVector(String layers, String styles, int width, int height, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        String str = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        str = str + "&layers=" + layers;
        str = str + "&format=image/png";
        str = str + "&bbox=" + lambertMin.east() + ",";
        str = str + lambertMin.north() + ",";
        str = str + lambertMax.east() + ",";
        str = str + lambertMax.north();
        str = str + "&width=" + width + "&height=" + height;
        str = str + "&exception=application/vnd.ogc.se_inimage";
        str = str + "&styles=" + styles;
        System.out.println("URL=" + str);
        return new URL(str.replace(" ", "%20"));
    }

    private URL getURLVector(EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        return this.buildURLVector(CadastrePlugin.grabLayers, CadastrePlugin.grabStyles, CadastrePlugin.imageWidth, CadastrePlugin.imageHeight, lambertMin, lambertMax);
    }

    private BufferedImage grab(URL url) throws IOException, OsmTransferException {
        this.wmsInterface.urlConn = (HttpURLConnection)url.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream is = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, NullProgressMonitor.INSTANCE);
        BufferedImage img = ImageIO.read((InputStream)is);
        is.close();
        return img;
    }

    public CadastreInterface getWmsInterface() {
        return this.wmsInterface;
    }
}

