/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpsblam;

import java.awt.Point;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSBlamInputData
extends LinkedList<CachedLatLon> {
    private Collection<Calendar> datesSeen = new HashSet<Calendar>();

    public int getNDays() {
        return this.datesSeen.size();
    }

    public GPSBlamInputData(Point p1, Point p2, int radius) {
        Collection layers = Main.map.mapView.getAllLayers();
        for (Layer l : layers) {
            if (!l.isVisible() || !(l instanceof GpxLayer)) continue;
            for (GpxTrack track : ((GpxLayer)l).data.tracks) {
                for (GpxTrackSegment segment : track.getSegments()) {
                    for (WayPoint wayPoint : segment.getWayPoints()) {
                        double distsq;
                        double dir_y;
                        if (p2.equals(p1)) {
                            CachedLatLon cll = new CachedLatLon(wayPoint.getCoor());
                            Point p = Main.map.mapView.getPoint(cll.getEastNorth());
                            if (!(p.distance(p1) < (double)radius)) continue;
                            this.add(cll, wayPoint);
                            continue;
                        }
                        double length = Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y)) + 1.0E-5;
                        double dir_x = (double)(p2.x - p1.x) / length;
                        double perpdir_x = dir_y = (double)(p2.y - p1.y) / length;
                        double perpdir_y = -dir_x;
                        CachedLatLon cll = new CachedLatLon(wayPoint.getCoor());
                        Point p = Main.map.mapView.getPoint(cll.getEastNorth());
                        double p_x = p.x - p1.x;
                        double p_y = p.y - p1.y;
                        double p_par = p_x * dir_x + p_y * dir_y;
                        double p_perp = p_x * perpdir_x + p_y * perpdir_y;
                        double pardist = 0.0;
                        if (p_par < 0.0) {
                            pardist = -p_par;
                        } else if (p_par > length) {
                            pardist = p_par - length;
                        }
                        if (!((distsq = pardist * pardist + p_perp * p_perp) < (double)(radius * radius))) continue;
                        this.add(cll, wayPoint);
                    }
                }
            }
        }
    }

    private void add(CachedLatLon cll, WayPoint wayPoint) {
        this.add(cll);
        GregorianCalendar day = new GregorianCalendar();
        day.setTimeInMillis((long)wayPoint.time * 1000L);
        day.set(11, 0);
        day.set(12, 0);
        day.set(13, 0);
        this.datesSeen.add(day);
    }
}

