/*
 * Decompiled with CFR 0.152.
 */
package relcontext;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import relcontext.ChosenRelationListener;

public class ChosenRelation
implements MapView.EditLayerChangeListener,
MapViewPaintable,
DataSetListener {
    protected Relation chosenRelation = null;
    private Set<ChosenRelationListener> chosenRelationListeners = new HashSet<ChosenRelationListener>();
    private static final String[] MULTIPOLYGON_TYPES = new String[]{"multipolygon", "boundary"};

    public void set(Relation rel) {
        if (rel == this.chosenRelation || rel != null && this.chosenRelation != null && rel.equals((Object)this.chosenRelation)) {
            return;
        }
        Relation oldRel = this.chosenRelation;
        this.chosenRelation = rel;
        this.analyse();
        Main.map.mapView.repaint();
        this.fireRelationChanged(oldRel);
    }

    protected void fireRelationChanged(Relation oldRel) {
        for (ChosenRelationListener listener : this.chosenRelationListeners) {
            listener.chosenRelationChanged(oldRel, this.chosenRelation);
        }
    }

    public Relation get() {
        return this.chosenRelation;
    }

    public void clear() {
        this.set(null);
    }

    public boolean isSame(Object r) {
        if (r == null) {
            return this.chosenRelation == null;
        }
        if (!(r instanceof Relation)) {
            return false;
        }
        return this.chosenRelation != null && r.equals(this.chosenRelation);
    }

    public boolean isMultipolygon() {
        return ChosenRelation.isMultipolygon(this.chosenRelation);
    }

    public static boolean isMultipolygon(Relation r) {
        if (r == null) {
            return false;
        }
        String type = r.get("type");
        if (type == null) {
            return false;
        }
        for (String t : MULTIPOLYGON_TYPES) {
            if (!t.equals(type)) continue;
            return true;
        }
        return false;
    }

    public int getSegmentsCount() {
        return 0;
    }

    public int getCirclesCount() {
        return 0;
    }

    protected void analyse() {
    }

    public void addChosenRelationListener(ChosenRelationListener listener) {
        this.chosenRelationListeners.add(listener);
    }

    public void removeChosenRelationListener(ChosenRelationListener listener) {
        this.chosenRelationListeners.remove(listener);
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        this.clear();
        if (newLayer != null && oldLayer == null) {
            Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        } else if (oldLayer != null) {
            Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        float opacity;
        if (this.chosenRelation == null) {
            return;
        }
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        float f = dataLayer == null ? 0.0f : (opacity = !dataLayer.isVisible() ? 0.0f : (float)dataLayer.getOpacity());
        if ((double)opacity < 0.01) {
            return;
        }
        Composite oldComposite = g.getComposite();
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(9.0f, 1, 1));
        g.setColor(Color.yellow);
        g.setComposite(AlphaComposite.getInstance(3, 0.3f * opacity));
        this.drawRelations(g, mv, bbox, this.chosenRelation);
        g.setComposite(oldComposite);
        g.setStroke(oldStroke);
    }

    private void drawRelations(Graphics2D g, MapView mv, Bounds bbox, Relation rel) {
        for (OsmPrimitive element : rel.getMemberPrimitives()) {
            if (element.getType() == OsmPrimitiveType.NODE) {
                Node node = (Node)element;
                Point center = mv.getPoint(node);
                g.drawOval(center.x - 4, center.y - 4, 9, 9);
                continue;
            }
            if (element.getType() == OsmPrimitiveType.WAY) {
                Way way = (Way)element;
                if (way.getNodesCount() < 2) continue;
                GeneralPath b = new GeneralPath();
                Point p = mv.getPoint(way.getNode(0));
                b.moveTo(p.x, p.y);
                for (int i = 1; i < way.getNodesCount(); ++i) {
                    p = mv.getPoint(way.getNode(i));
                    b.lineTo(p.x, p.y);
                }
                g.draw(b);
                continue;
            }
            if (element.getType() != OsmPrimitiveType.RELATION) continue;
            Color oldColor = g.getColor();
            g.setColor(Color.magenta);
            this.drawRelations(g, mv, bbox, (Relation)element);
            g.setColor(oldColor);
        }
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
        if (this.chosenRelation != null && event.getRelation().equals((Object)this.chosenRelation)) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void tagsChanged(TagsChangedEvent event) {
        if (this.chosenRelation != null && event.getPrimitive().equals((Object)this.chosenRelation)) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void dataChanged(DataChangedEvent event) {
        if (this.chosenRelation != null) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        if (this.chosenRelation != null && event.getPrimitives().contains(this.chosenRelation)) {
            this.clear();
        }
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        if (this.chosenRelation != null) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }
}

