/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets.at;

import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.DefaultGmlHandler;

public class AustrianGmlHandler
extends DefaultGmlHandler {
    @Override
    public CoordinateReferenceSystem getCrsFor(String crsName) throws NoSuchAuthorityCodeException, FactoryException {
        if (crsName != null && crsName.startsWith("AUT")) {
            if (crsName.equalsIgnoreCase("AUT-GK28")) {
                return CRS.decode("EPSG:31281");
            }
            if (crsName.equalsIgnoreCase("AUT-GK31")) {
                return CRS.decode("EPSG:31282");
            }
            if (crsName.equalsIgnoreCase("AUT-GK34")) {
                return CRS.decode("EPSG:31283");
            }
            if (crsName.equalsIgnoreCase("AUT-GK28-5")) {
                return CRS.decode("EPSG:31251");
            }
            if (crsName.equalsIgnoreCase("AUT-GK31-5")) {
                return CRS.decode("EPSG:31252");
            }
            if (crsName.equalsIgnoreCase("AUT-GK34-5")) {
                return CRS.decode("EPSG:31253");
            }
            if (crsName.equalsIgnoreCase("AUT-BM28")) {
                return CRS.decode("EPSG:31288");
            }
            if (crsName.equalsIgnoreCase("AUT-BM31")) {
                return CRS.decode("EPSG:31289");
            }
            if (crsName.equalsIgnoreCase("AUT-BM34")) {
                return CRS.decode("EPSG:31290");
            }
            if (crsName.equalsIgnoreCase("AUT-LM")) {
                return CRS.decode("EPSG:31287");
            }
            if (crsName.equalsIgnoreCase("AUT-LL-BESSEL")) {
                // empty if block
            }
        }
        return super.getCrsFor(crsName);
    }
}

