/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;

public class Element
extends Content
implements Parent {
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String name;
    protected transient Namespace namespace;
    protected transient List additionalNamespaces;
    AttributeList attributes = new AttributeList(this);
    ContentList content = new ContentList(this);

    protected Element() {
    }

    public Element(String string, Namespace namespace) {
        this.setName(string);
        this.setNamespace(namespace);
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String string) {
        String string2 = Verifier.checkElementName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "element", string2);
        }
        this.name = string;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        String string;
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if ((string = Verifier.checkNamespaceCollision(namespace, this.getAdditionalNamespaces())) != null) {
            throw new IllegalAddException(this, namespace, string);
        }
        for (Attribute attribute : this.getAttributes()) {
            string = Verifier.checkNamespaceCollision(namespace, attribute);
            if (string == null) continue;
            throw new IllegalAddException(this, namespace, string);
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String string) {
        if (string == null) {
            return null;
        }
        if ("xml".equals(string)) {
            return Namespace.XML_NAMESPACE;
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            for (int i = 0; i < this.additionalNamespaces.size(); ++i) {
                Object object = (Namespace)this.additionalNamespaces.get(i);
                if (!string.equals(((Namespace)object).getPrefix())) continue;
                return object;
            }
        }
        if (this.attributes != null) {
            for (Object object : this.attributes) {
                if (!string.equals(((Attribute)object).getNamespacePrefix())) continue;
                return ((Attribute)object).getNamespace();
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(string);
        }
        return null;
    }

    public String getQualifiedName() {
        if ("".equals(this.namespace.getPrefix())) {
            return this.getName();
        }
        return new StringBuffer(this.namespace.getPrefix()).append(':').append(this.name).toString();
    }

    public void addNamespaceDeclaration(Namespace namespace) {
        String string = Verifier.checkNamespaceCollision(namespace, this);
        if (string != null) {
            throw new IllegalAddException(this, namespace, string);
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(namespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    @Override
    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Content content : this.getContent()) {
            if (!(content instanceof Element) && !(content instanceof Text)) continue;
            stringBuffer.append(content.getValue());
        }
        return stringBuffer.toString();
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Object object = this.content.get(0);
            if (object instanceof Text) {
                return ((Text)object).getText();
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.content.size(); ++i) {
            Object object = this.content.get(i);
            if (!(object instanceof Text)) continue;
            stringBuffer.append(((Text)object).getText());
            bl = true;
        }
        if (!bl) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getChildText(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public Element setText(String string) {
        this.content.clear();
        if (string != null) {
            this.addContent(new Text(string));
        }
        return this;
    }

    @Override
    public List getContent() {
        return this.content;
    }

    public Element addContent(Content content) {
        this.content.add(content);
        return this;
    }

    @Override
    public boolean removeContent(Content content) {
        return this.content.remove(content);
    }

    public boolean isAncestor(Element element) {
        Parent parent = element.getParent();
        while (parent instanceof Element) {
            if (parent == this) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String string, Namespace namespace) {
        return (Attribute)this.attributes.get(string, namespace);
    }

    public String getAttributeValue(String string, Namespace namespace) {
        return this.getAttributeValue(string, namespace, null);
    }

    public String getAttributeValue(String string, Namespace namespace, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string, namespace);
        if (attribute == null) {
            return string2;
        }
        return attribute.getValue();
    }

    public Element setAttribute(String string, String string2, Namespace namespace) {
        Attribute attribute = this.getAttribute(string, namespace);
        if (attribute == null) {
            Attribute attribute2 = new Attribute(string, string2, namespace);
            this.setAttribute(attribute2);
        } else {
            attribute.setValue(string2);
        }
        return this;
    }

    public Element setAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean removeAttribute(String string, Namespace namespace) {
        return this.attributes.remove(string, namespace);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String string = this.getNamespaceURI();
        if (!"".equals(string)) {
            stringBuffer.append(" [Namespace: ").append(string).append("]");
        }
        stringBuffer.append("/>]");
        return stringBuffer.toString();
    }

    @Override
    public Object clone() {
        Cloneable cloneable;
        int n;
        Element element = (Element)super.clone();
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        if (this.attributes != null) {
            for (n = 0; n < this.attributes.size(); ++n) {
                cloneable = (Attribute)this.attributes.get(n);
                element.attributes.add(((Attribute)cloneable).clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList(this.additionalNamespaces);
        }
        if (this.content != null) {
            for (n = 0; n < this.content.size(); ++n) {
                cloneable = (Content)this.content.get(n);
                element.content.add(((Content)cloneable).clone());
            }
        }
        return element;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
        if (this.additionalNamespaces == null) {
            objectOutputStream.write(0);
        } else {
            int n = this.additionalNamespaces.size();
            objectOutputStream.write(n);
            for (int i = 0; i < n; ++i) {
                Namespace namespace = (Namespace)this.additionalNamespaces.get(i);
                objectOutputStream.writeObject(namespace.getPrefix());
                objectOutputStream.writeObject(namespace.getURI());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
        int n = objectInputStream.read();
        if (n != 0) {
            this.additionalNamespaces = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                Namespace namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
                this.additionalNamespaces.add(namespace);
            }
        }
    }

    @Override
    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    public List getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public List getChildren(String string, Namespace namespace) {
        return this.content.getView(new ElementFilter(string, namespace));
    }

    public Element getChild(String string, Namespace namespace) {
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public Element getChild(String string) {
        return this.getChild(string, Namespace.NO_NAMESPACE);
    }
}

