/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.Iterator;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;

public class Document
implements Parent {
    ContentList content = new ContentList(this);

    public Document() {
    }

    public Document(Element element, DocType docType, String string) {
        if (element != null) {
            this.setRootElement(element);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (string != null) {
            this.setBaseURI(string);
        }
    }

    public Document(Element element) {
        this(element, null, null);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(n);
    }

    public Document setRootElement(Element element) {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            this.content.add(element);
        } else {
            this.content.set(n, element);
        }
        return this;
    }

    public DocType getDocType() {
        int n = this.content.indexOfDocType();
        if (n < 0) {
            return null;
        }
        return (DocType)this.content.get(n);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int n = this.content.indexOfDocType();
            if (n >= 0) {
                this.content.remove(n);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int n = this.content.indexOfDocType();
        if (n < 0) {
            this.content.add(0, docType);
        } else {
            this.content.set(n, docType);
        }
        return this;
    }

    public Document addContent(Content content) {
        this.content.add(content);
        return this;
    }

    @Override
    public List getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    public final void setBaseURI(String string) {
    }

    @Override
    public boolean removeContent(Content content) {
        return this.content.remove(content);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringBuffer.append(docType.toString()).append(", ");
        } else {
            stringBuffer.append(" No DOCTYPE declaration, ");
        }
        if (this.hasRootElement()) {
            stringBuffer.append("Root is ").append(this.getRootElement().toString());
        } else {
            stringBuffer.append(" No root element");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object clone() {
        Document document = null;
        try {
            document = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        document.content = new ContentList(document);
        for (int i = 0; i < this.content.size(); ++i) {
            Content content;
            Object object = this.content.get(i);
            if (object instanceof Element) {
                content = (Element)((Element)object).clone();
                document.content.add(content);
                continue;
            }
            if (object instanceof Comment) {
                content = (Comment)((Comment)object).clone();
                document.content.add(content);
                continue;
            }
            if (object instanceof ProcessingInstruction) {
                content = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                document.content.add(content);
                continue;
            }
            if (!(object instanceof DocType)) continue;
            content = (DocType)((DocType)object).clone();
            document.content.add(content);
        }
        return document;
    }

    @Override
    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    @Override
    public Parent getParent() {
        return null;
    }

    @Override
    public Document getDocument() {
        return this;
    }
}

