/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.geotools.util.logging.Logging;

public final class WeakCollectionCleaner
extends Thread {
    public static final WeakCollectionCleaner DEFAULT = new WeakCollectionCleaner();
    ReferenceQueue<Object> referenceQueue = new ReferenceQueue();

    private WeakCollectionCleaner() {
        super("WeakCollectionCleaner");
        this.setPriority(8);
        this.setDaemon(true);
        this.start();
    }

    public synchronized ReferenceQueue<Object> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    public void run() {
        ReferenceQueue<Object> referenceQueue;
        while ((referenceQueue = this.getReferenceQueue()) != null) {
            try {
                Reference<Object> reference = referenceQueue.remove();
                if (reference == null) {
                    WeakCollectionCleaner.sleep(15000L);
                    break;
                }
                reference.clear();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                Logging.unexpectedException(WeakCollectionCleaner.class, "remove", exception);
            }
            catch (AssertionError assertionError) {
                Logging.unexpectedException(WeakCollectionCleaner.class, "remove", (Throwable)((Object)assertionError));
            }
        }
        Logging.getLogger(WeakCollectionCleaner.class).info("Weak collection cleaner stopped");
    }
}

