/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.Map;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;

public class MapEntry<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 8627698052283756776L;
    private final K key;
    private final V value;

    public MapEntry(K k, V v) {
        this.key = k;
        this.value = v;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return Utilities.equals(this.getKey(), entry.getKey()) && Utilities.equals(this.getValue(), entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        if (this.key != null) {
            n = this.key.hashCode();
        }
        if (this.value != null) {
            n ^= this.value.hashCode();
        }
        return n;
    }

    public String toString() {
        return Classes.getShortClassName(this) + "[key=" + this.key + ", value=" + this.value + ']';
    }
}

