/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.geotools.resources.BufferSoftReference;
import org.geotools.util.logging.Logging;

public final class NIOUtilities {
    static Map<Integer, Queue<Object>> cache = new ConcurrentHashMap<Integer, Queue<Object>>();
    static Map<Class, Method> cleanerMethodCache = new ConcurrentHashMap<Class, Method>();
    static int maxCacheSize = 0x200000;
    static AtomicInteger hardCacheSize = new AtomicInteger(0);
    private static boolean warned = false;
    private static boolean directBuffersEnabled = true;

    private NIOUtilities() {
    }

    public static ByteBuffer allocate(int n) {
        Queue<Object> queue = NIOUtilities.getBuffers(n);
        Object object = null;
        while ((object = queue.poll()) != null) {
            ByteBuffer byteBuffer = null;
            if (object instanceof BufferSoftReference) {
                byteBuffer = (ByteBuffer)((BufferSoftReference)object).get();
            } else {
                byteBuffer = (ByteBuffer)object;
                hardCacheSize.addAndGet(-byteBuffer.capacity());
            }
            if (byteBuffer == null) continue;
            byteBuffer.clear();
            return byteBuffer;
        }
        if (directBuffersEnabled) {
            return ByteBuffer.allocateDirect(n);
        }
        return ByteBuffer.allocate(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<Object> getBuffers(int n) {
        Queue<Object> queue = cache.get(n);
        if (queue == null) {
            Map<Integer, Queue<Object>> map = cache;
            synchronized (map) {
                queue = cache.get(n);
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue<Object>();
                    cache.put(n, queue);
                }
            }
        }
        return queue;
    }

    public static boolean clean(ByteBuffer byteBuffer, boolean bl) {
        if (bl) {
            return NIOUtilities.clean(byteBuffer);
        }
        if (NIOUtilities.returnToCache(byteBuffer)) {
            return true;
        }
        return NIOUtilities.clean(byteBuffer);
    }

    public static boolean clean(final ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.isDirect()) {
            return true;
        }
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean bl;
                block3: {
                    bl = Boolean.FALSE;
                    try {
                        Object object;
                        Method method = NIOUtilities.getCleanerMethod(byteBuffer);
                        if (method != null && (object = method.invoke((Object)byteBuffer, (Object[])null)) != null) {
                            Method method2 = object.getClass().getMethod("clean", null);
                            method2.invoke(object, (Object[])null);
                            bl = Boolean.TRUE;
                        }
                    }
                    catch (Exception exception) {
                        if (!NIOUtilities.isLoggable()) break block3;
                        NIOUtilities.log(exception, byteBuffer);
                    }
                }
                return bl;
            }
        });
        return bl;
    }

    static Method getCleanerMethod(ByteBuffer byteBuffer) throws NoSuchMethodException {
        Method method = cleanerMethodCache.get(byteBuffer.getClass());
        if (method == null) {
            method = byteBuffer.getClass().getMethod("cleaner", null);
            method.setAccessible(true);
            cleanerMethodCache.put(byteBuffer.getClass(), method);
        }
        return method;
    }

    public static boolean returnToCache(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.capacity();
        if (n2 != 100 && n2 != 13 && n2 != 16000 && (n = (int)Math.pow(2.0, Math.ceil(Math.log(n2) / Math.log(2.0)))) != n2) {
            return false;
        }
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        Queue<Object> queue = cache.get(n2);
        if (hardCacheSize.get() > maxCacheSize) {
            queue.add(new BufferSoftReference(byteBuffer));
        } else {
            hardCacheSize.addAndGet(n2);
            queue.add(byteBuffer);
        }
        return true;
    }

    private static synchronized boolean isLoggable() {
        try {
            return !warned && (Boolean.getBoolean("org.geotools.io.debugBuffer") || System.getProperty("os.name").indexOf("Windows") >= 0);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static synchronized void log(Exception exception, ByteBuffer byteBuffer) {
        warned = true;
        String string = "Error attempting to close a mapped byte buffer : " + byteBuffer.getClass().getName() + "\n JVM : " + System.getProperty("java.version") + ' ' + System.getProperty("java.vendor");
        Logging.getLogger("org.geotools.io").log(Level.SEVERE, string, exception);
    }

    static {
        String string = System.getProperty("geotools.nioutilities.direct", "true");
        directBuffersEnabled = "TRUE".equalsIgnoreCase(string);
    }
}

