/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class IdentityTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -5339040282922138164L;
    private final int dimension;
    private static final LinearTransform[] POOL = new LinearTransform[8];

    protected IdentityTransform(int n) {
        this.dimension = n;
    }

    public static synchronized LinearTransform create(int n) {
        LinearTransform linearTransform;
        if (n < POOL.length && (linearTransform = POOL[n]) != null) {
            return linearTransform;
        }
        switch (n) {
            case 1: {
                linearTransform = LinearTransform1D.IDENTITY;
                break;
            }
            case 2: {
                linearTransform = new AffineTransform2D(new AffineTransform());
                break;
            }
            default: {
                linearTransform = new IdentityTransform(n);
            }
        }
        if (n < POOL.length) {
            IdentityTransform.POOL[n] = linearTransform;
        }
        return linearTransform;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public boolean isIdentity(double d) {
        return true;
    }

    @Override
    public int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return ProjectiveTransform.ProviderAffine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public Matrix getMatrix() {
        return MatrixFactory.create(this.dimension + 1);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return MatrixFactory.create(this.dimension);
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        if (directPosition.getDimension() == this.dimension) {
            if (directPosition2 == null) {
                return new GeneralDirectPosition(directPosition);
            }
            if (directPosition2.getDimension() == this.dimension) {
                for (int i = 0; i < this.dimension; ++i) {
                    directPosition2.setOrdinate(i, directPosition.getOrdinate(i));
                }
                return directPosition2;
            }
        }
        try {
            return super.transform(directPosition, directPosition2);
        }
        catch (TransformException transformException) {
            throw new AssertionError((Object)transformException);
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        System.arraycopy(fArray, n, fArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3 * this.dimension);
    }

    @Override
    public MathTransform inverse() {
        return this;
    }

    @Override
    public int hashCode() {
        return 1861010892 + this.dimension;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdentityTransform identityTransform = (IdentityTransform)object;
            return this.dimension == identityTransform.dimension;
        }
        return false;
    }
}

