/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.LogarithmicTransform1D;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

public class ExponentialTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = 5331178990358868947L;
    public final double base;
    final double lnBase;
    public final double scale;
    private MathTransform1D inverse;

    ExponentialTransform1D(LogarithmicTransform1D logarithmicTransform1D) {
        this.base = logarithmicTransform1D.base;
        this.lnBase = logarithmicTransform1D.lnBase;
        this.scale = Math.pow(this.base, -logarithmicTransform1D.offset);
        this.inverse = logarithmicTransform1D;
    }

    protected ExponentialTransform1D(double d, double d2) {
        this.base = d;
        this.scale = d2;
        this.lnBase = Math.log(d);
    }

    public static MathTransform1D create(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return LinearTransform1D.create(0.0, 0.0);
        }
        if (d == 1.0) {
            return LinearTransform1D.create(0.0, d2);
        }
        return new ExponentialTransform1D(d, d2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), new ParameterValue[]{new FloatParameter(Provider.BASE, this.base), new FloatParameter(Provider.SCALE, this.scale)});
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = LogarithmicTransform1D.create(this);
        }
        return this.inverse;
    }

    @Override
    public double derivative(double d) {
        return this.lnBase * this.transform(d);
    }

    @Override
    public double transform(double d) {
        return this.scale * Math.pow(this.base, d);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(this.scale * Math.pow(this.base, fArray[n++]));
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(this.scale * Math.pow(this.base, fArray[--n]));
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = this.scale * Math.pow(this.base, dArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = this.scale * Math.pow(this.base, dArray[--n]);
            }
        }
    }

    @Override
    MathTransform concatenate(MathTransform mathTransform, boolean bl) {
        if (mathTransform instanceof LinearTransform) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)mathTransform;
            if (bl) {
                double d = Math.pow(this.base, linearTransform1D.scale);
                double d2 = Math.pow(this.base, linearTransform1D.offset) * this.scale;
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    return ExponentialTransform1D.create(d, d2);
                }
            } else if (linearTransform1D.offset == 0.0) {
                return ExponentialTransform1D.create(this.base, this.scale * linearTransform1D.scale);
            }
        } else if (mathTransform instanceof LogarithmicTransform1D) {
            return this.concatenateLog((LogarithmicTransform1D)mathTransform, bl);
        }
        return super.concatenate(mathTransform, bl);
    }

    MathTransform concatenateLog(LogarithmicTransform1D logarithmicTransform1D, boolean bl) {
        if (bl) {
            double d = this.scale * Math.pow(this.base, logarithmicTransform1D.offset);
            double d2 = this.lnBase / logarithmicTransform1D.lnBase;
            if (!Double.isNaN(d) && d2 == 1.0) {
                return LinearTransform1D.create(d, 0.0);
            }
        } else if (this.scale > 0.0) {
            return LinearTransform1D.create(this.lnBase / logarithmicTransform1D.lnBase, Math.log(this.scale) / logarithmicTransform1D.lnBase + logarithmicTransform1D.offset);
        }
        return null;
    }

    @Override
    public int hashCode() {
        long l = 5331178990358868947L + Double.doubleToLongBits(this.base);
        l = l * 37L + Double.doubleToLongBits(this.scale);
        return (int)(l >>> 32) ^ (int)l;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ExponentialTransform1D exponentialTransform1D = (ExponentialTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(exponentialTransform1D.base) && Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(exponentialTransform1D.scale);
        }
        return false;
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -5838840021166379987L;
        public static final ParameterDescriptor BASE = LogarithmicTransform1D.Provider.BASE;
        public static final ParameterDescriptor SCALE = DefaultParameterDescriptor.create("scale", 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(68))}, new ParameterDescriptor[]{BASE, SCALE});

        public Provider() {
            super(1, 1, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform1D createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            return ExponentialTransform1D.create(Provider.doubleValue(BASE, parameterValueGroup), Provider.doubleValue(SCALE, parameterValueGroup));
        }
    }
}

