/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.math.XMath;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;

public abstract class MapProjection
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    private static final long serialVersionUID = -406751619777246914L;
    protected static final Logger LOGGER = Logging.getLogger(MapProjection.class);
    private static final double EPSILON = 1.0E-6;
    private static final double ANGLE_TOLERANCE = 1.0E-4;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double MLFN_TOL = 1.0E-11;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    protected final double excentricity;
    protected final double excentricitySquared;
    protected final boolean isSpherical;
    protected final double semiMajor;
    protected final double semiMinor;
    protected double centralMeridian;
    protected double latitudeOfOrigin;
    protected double scaleFactor;
    protected final double falseEasting;
    protected final double falseNorthing;
    protected double globalScale;
    private transient MathTransform2D inverse;
    protected double en0;
    protected double en1;
    protected double en2;
    protected double en3;
    protected double en4;
    private transient int rangeCheckSemaphore;
    private static int globalRangeCheckSemaphore = 1;
    protected boolean invertible = true;

    protected MapProjection(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        this(parameterValueGroup, null);
    }

    MapProjection(ParameterValueGroup parameterValueGroup, Collection<GeneralParameterDescriptor> collection) throws ParameterNotFoundException {
        if (collection == null) {
            collection = this.getParameterDescriptors().descriptors();
        }
        this.semiMajor = this.doubleValue(collection, AbstractProvider.SEMI_MAJOR, parameterValueGroup);
        this.semiMinor = this.doubleValue(collection, AbstractProvider.SEMI_MINOR, parameterValueGroup);
        this.centralMeridian = this.doubleValue(collection, AbstractProvider.CENTRAL_MERIDIAN, parameterValueGroup);
        this.latitudeOfOrigin = this.doubleValue(collection, AbstractProvider.LATITUDE_OF_ORIGIN, parameterValueGroup);
        this.scaleFactor = this.doubleValue(collection, AbstractProvider.SCALE_FACTOR, parameterValueGroup);
        this.falseEasting = this.doubleValue(collection, AbstractProvider.FALSE_EASTING, parameterValueGroup);
        this.falseNorthing = this.doubleValue(collection, AbstractProvider.FALSE_NORTHING, parameterValueGroup);
        this.isSpherical = this.semiMajor == this.semiMinor;
        this.excentricitySquared = 1.0 - this.semiMinor * this.semiMinor / (this.semiMajor * this.semiMajor);
        this.excentricity = Math.sqrt(this.excentricitySquared);
        this.globalScale = this.scaleFactor * this.semiMajor;
        MapProjection.ensureLongitudeInRange(AbstractProvider.CENTRAL_MERIDIAN, this.centralMeridian, true);
        MapProjection.ensureLatitudeInRange(AbstractProvider.LATITUDE_OF_ORIGIN, this.latitudeOfOrigin, true);
        this.en0 = 1.0 - this.excentricitySquared * (0.25 + this.excentricitySquared * (0.046875 + this.excentricitySquared * (0.01953125 + this.excentricitySquared * 0.01068115234375)));
        this.en1 = this.excentricitySquared * (0.75 - this.excentricitySquared * (0.046875 + this.excentricitySquared * (0.01953125 + this.excentricitySquared * 0.01068115234375)));
        double d = this.excentricitySquared * this.excentricitySquared;
        this.en2 = d * (0.46875 - this.excentricitySquared * (0.013020833333333334 + this.excentricitySquared * 0.007120768229166667));
        this.en3 = (d *= this.excentricitySquared) * (0.3645833333333333 - this.excentricitySquared * 0.005696614583333333);
        this.en4 = d * this.excentricitySquared * 0.3076171875;
    }

    boolean isExpectedParameter(Collection<GeneralParameterDescriptor> collection, ParameterDescriptor parameterDescriptor) {
        return collection.contains(parameterDescriptor);
    }

    final double doubleValue(Collection<GeneralParameterDescriptor> collection, ParameterDescriptor parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        double d;
        if (this.isExpectedParameter(collection, parameterDescriptor)) {
            return AbstractProvider.doubleValue(parameterDescriptor, parameterValueGroup);
        }
        Object t = parameterDescriptor.getDefaultValue();
        if (t instanceof Number) {
            d = ((Number)t).doubleValue();
            if (NonSI.DEGREE_ANGLE.equals(parameterDescriptor.getUnit())) {
                d = Math.toRadians(d);
            }
        } else {
            d = Double.NaN;
        }
        return d;
    }

    final void ensureSpherical() throws IllegalArgumentException {
        if (!this.isSpherical) {
            throw new IllegalArgumentException(Errors.format(45));
        }
    }

    static void ensureLatitudeInRange(ParameterDescriptor parameterDescriptor, double d, boolean bl) throws IllegalArgumentException {
        if (bl ? d >= -1.5707963267948966 && d <= 1.5707963267948966 : d > -1.5707963267948966 && d < 1.5707963267948966) {
            return;
        }
        d = Math.toDegrees(d);
        throw new InvalidParameterValueException(Errors.format(85, new Latitude(d)), parameterDescriptor.getName().getCode(), d);
    }

    static void ensureLongitudeInRange(ParameterDescriptor parameterDescriptor, double d, boolean bl) throws IllegalArgumentException {
        if (bl ? d >= -Math.PI && d <= Math.PI : d > -Math.PI && d < Math.PI) {
            return;
        }
        d = Math.toDegrees(d);
        throw new InvalidParameterValueException(Errors.format(88, new Longitude(d)), parameterDescriptor.getName().getCode(), d);
    }

    private static boolean verifyGeographicRanges(AbstractMathTransform abstractMathTransform, double d, double d2) {
        boolean bl;
        boolean bl2 = d < -180.0001 || d > 180.0001;
        boolean bl3 = bl = d2 < -90.0001 || d2 > 90.0001;
        if (!bl2 && !bl) {
            return false;
        }
        String string = System.getProperty("line.separator", "\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Errors.format(153, abstractMathTransform.getName()));
        if (bl2) {
            stringBuilder.append(string);
            stringBuilder.append(Errors.format(88, new Longitude(d)));
        }
        if (bl) {
            stringBuilder.append(string);
            stringBuilder.append(Errors.format(85, new Latitude(d2)));
        }
        LogRecord logRecord = new LogRecord(Level.WARNING, stringBuilder.toString());
        String string2 = abstractMathTransform instanceof Inverse ? ((Inverse)abstractMathTransform).inverse().getClass().getName() + ".Inverse" : abstractMathTransform.getClass().getName();
        logRecord.setSourceClassName(string2);
        logRecord.setSourceMethodName("transform");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
        return true;
    }

    final void set(Collection<GeneralParameterDescriptor> collection, ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup, double d) {
        if (this.isExpectedParameter(collection, parameterDescriptor)) {
            if (NonSI.DEGREE_ANGLE.equals(parameterDescriptor.getUnit())) {
                double d2;
                double d3 = d = Math.toDegrees(d);
                if ((d = XMath.trimDecimalFractionDigits(d, 4, 12)) == d3 && (d2 = XMath.trimDecimalFractionDigits(d3 *= 3.0, 4, 12)) != d3) {
                    d = d2 / 3.0;
                }
            }
            parameterValueGroup.parameter(parameterDescriptor.getName().getCode()).setValue(d);
        }
    }

    @Override
    public abstract ParameterDescriptorGroup getParameterDescriptors();

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        ParameterValueGroup parameterValueGroup = parameterDescriptorGroup.createValue();
        this.set(list, AbstractProvider.SEMI_MAJOR, parameterValueGroup, this.semiMajor);
        this.set(list, AbstractProvider.SEMI_MINOR, parameterValueGroup, this.semiMinor);
        this.set(list, AbstractProvider.CENTRAL_MERIDIAN, parameterValueGroup, this.centralMeridian);
        this.set(list, AbstractProvider.LATITUDE_OF_ORIGIN, parameterValueGroup, this.latitudeOfOrigin);
        this.set(list, AbstractProvider.SCALE_FACTOR, parameterValueGroup, this.scaleFactor);
        this.set(list, AbstractProvider.FALSE_EASTING, parameterValueGroup, this.falseEasting);
        this.set(list, AbstractProvider.FALSE_NORTHING, parameterValueGroup, this.falseNorthing);
        return parameterValueGroup;
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    private double orthodromicDistance(Point2D point2D, Point2D point2D2) {
        double d = Math.toRadians(point2D.getY());
        double d2 = Math.toRadians(point2D2.getY());
        double d3 = Math.toRadians(Math.abs(point2D2.getX() - point2D.getX()) % 360.0);
        double d4 = Math.sin(d) * Math.sin(d2) + Math.cos(d) * Math.cos(d2) * Math.cos(d3);
        if (d4 > 1.0) {
            assert (d4 <= 1.000001) : d4;
            d4 = 1.0;
        }
        if (d4 < -1.0) {
            assert (d4 >= -1.000001) : d4;
            d4 = -1.0;
        }
        return Math.acos(d4) * this.semiMajor;
    }

    private boolean checkReciprocal(Point2D point2D, Point2D point2D2, boolean bl) throws ProjectionException {
        if (!(point2D instanceof CheckPoint)) {
            try {
                double d;
                double d2;
                double d3;
                point2D = new CheckPoint(point2D);
                if (bl) {
                    point2D = this.inverse().transform(point2D, point2D);
                    d3 = this.orthodromicDistance(point2D, point2D2);
                    d2 = point2D.getX();
                    d = point2D.getY();
                } else {
                    d2 = point2D.getX();
                    d = point2D.getY();
                    point2D = this.transform(point2D, point2D);
                    d3 = point2D.distance(point2D2);
                }
                if (d3 > this.getToleranceForAssertions(d2, d)) {
                    throw new ProjectionException(Errors.format(161, d3, new Longitude(d2 - Math.toDegrees(this.centralMeridian)), new Latitude(d - Math.toDegrees(this.latitudeOfOrigin)), this.getName()));
                }
            }
            catch (ProjectionException projectionException) {
                throw projectionException;
            }
            catch (TransformException transformException) {
                throw new ProjectionException(transformException);
            }
        }
        return true;
    }

    static boolean checkTransform(double d, double d2, Point2D point2D, double d3) {
        MapProjection.compare("x", point2D.getX(), d, d3);
        MapProjection.compare("y", point2D.getY(), d2, d3);
        return d3 < Double.POSITIVE_INFINITY;
    }

    static boolean checkTransform(double d, double d2, Point2D point2D) {
        return MapProjection.checkTransform(d, d2, point2D, 1.0E-6);
    }

    static boolean checkInverseTransform(double d, double d2, Point2D point2D, double d3) {
        MapProjection.compare("latitude", point2D.getY(), d2, d3);
        if (Math.abs(1.5707963267948966 - Math.abs(d2)) > 1.0E-6) {
            MapProjection.compare("longitude", point2D.getX(), d, d3);
        }
        return d3 < Double.POSITIVE_INFINITY;
    }

    static boolean checkInverseTransform(double d, double d2, Point2D point2D) {
        return MapProjection.checkInverseTransform(d, d2, point2D, 1.0E-6);
    }

    private static void compare(String string, double d, double d2, double d3) {
        if (Math.abs(d - d2) > d3) {
            if (string.charAt(0) == 'l') {
                d2 = Math.toDegrees(d2);
                d = Math.toDegrees(d);
            }
            throw new AssertionError((Object)Errors.format(167, string, d, d2));
        }
    }

    protected abstract Point2D inverseTransformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    protected abstract Point2D transformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    @Override
    public final Point2D transform(Point2D point2D, Point2D point2D2) throws ProjectionException {
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (this.verifyCoordinateRanges() && MapProjection.verifyGeographicRanges(this, d, d2)) {
            this.warningLogged();
        }
        point2D2 = this.transformNormalized(this.centralMeridian != 0.0 ? MapProjection.rollLongitude(Math.toRadians(d) - this.centralMeridian) : Math.toRadians(d), Math.toRadians(d2), point2D2);
        point2D2.setLocation(this.globalScale * point2D2.getX() + this.falseEasting, this.globalScale * point2D2.getY() + this.falseNorthing);
        if (this.invertible) assert (this.checkReciprocal(point2D2, point2D != point2D2 ? point2D : new Point2D.Double(d, d2), true));
        return point2D2;
    }

    @Override
    public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws ProjectionException {
        boolean bl;
        boolean bl2 = bl = dArray == dArray2 && n < n2 && n + 2 * n3 > n2;
        if (bl) {
            n += 2 * n3;
            n2 += 2 * n3;
        }
        Point2D.Double double_ = new Point2D.Double();
        ProjectionException projectionException = null;
        while (--n3 >= 0) {
            block5: {
                try {
                    double_.x = dArray[n++];
                    double_.y = dArray[n++];
                    this.transform(double_, double_);
                    dArray2[n2++] = double_.x;
                    dArray2[n2++] = double_.y;
                }
                catch (ProjectionException projectionException2) {
                    dArray2[n2++] = Double.NaN;
                    dArray2[n2++] = Double.NaN;
                    if (projectionException != null) break block5;
                    projectionException = projectionException2;
                }
            }
            if (!bl) continue;
            n -= 4;
            n2 -= 4;
        }
        if (projectionException != null) {
            throw projectionException;
        }
    }

    @Override
    public final void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws ProjectionException {
        boolean bl;
        boolean bl2 = bl = fArray == fArray2 && n < n2 && n + 2 * n3 > n2;
        if (bl) {
            n += 2 * n3;
            n2 += 2 * n3;
        }
        Point2D.Double double_ = new Point2D.Double();
        ProjectionException projectionException = null;
        while (--n3 >= 0) {
            block5: {
                try {
                    double_.x = fArray[n++];
                    double_.y = fArray[n++];
                    this.transform(double_, double_);
                    fArray2[n2++] = (float)double_.x;
                    fArray2[n2++] = (float)double_.y;
                }
                catch (ProjectionException projectionException2) {
                    fArray2[n2++] = Float.NaN;
                    fArray2[n2++] = Float.NaN;
                    if (projectionException != null) break block5;
                    projectionException = projectionException2;
                }
            }
            if (!bl) continue;
            n -= 4;
            n2 -= 4;
        }
        if (projectionException != null) {
            throw projectionException;
        }
    }

    @Override
    public final MathTransform2D inverse() throws NoninvertibleTransformException {
        if (!this.invertible) {
            throw new NoninvertibleTransformException(Errors.format(105));
        }
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    protected double getToleranceForAssertions(double d, double d2) {
        double d3 = Math.abs(d - this.centralMeridian) / 2.0 + Math.abs(d2 - this.latitudeOfOrigin);
        if (d3 > 40.0) {
            return 1.0;
        }
        return Math.abs(d) > 179.0 || Math.abs(d2) > 89.0 ? 0.1 : 1.0E-5;
    }

    final boolean verifyCoordinateRanges() {
        return this.rangeCheckSemaphore != globalRangeCheckSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void warningLogged() {
        Class<MapProjection> clazz = MapProjection.class;
        synchronized (MapProjection.class) {
            this.rangeCheckSemaphore = globalRangeCheckSemaphore;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.semiMajor);
        l = l * 37L + Double.doubleToLongBits(this.semiMinor);
        l = l * 37L + Double.doubleToLongBits(this.centralMeridian);
        l = l * 37L + Double.doubleToLongBits(this.latitudeOfOrigin);
        return (int)l ^ (int)(l >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MapProjection mapProjection = (MapProjection)object;
            return MapProjection.equals(this.semiMajor, mapProjection.semiMajor) && MapProjection.equals(this.semiMinor, mapProjection.semiMinor) && MapProjection.equals(this.centralMeridian, mapProjection.centralMeridian) && MapProjection.equals(this.latitudeOfOrigin, mapProjection.latitudeOfOrigin) && MapProjection.equals(this.scaleFactor, mapProjection.scaleFactor) && MapProjection.equals(this.falseEasting, mapProjection.falseEasting) && MapProjection.equals(this.falseNorthing, mapProjection.falseNorthing);
        }
        return false;
    }

    static boolean equals(double d, double d2) {
        return Utilities.equals(d, d2);
    }

    final double cphi2(double d) throws ProjectionException {
        double d2 = 0.5 * this.excentricity;
        double d3 = 1.5707963267948966 - 2.0 * Math.atan(d);
        for (int i = 0; i < 15; ++i) {
            double d4 = this.excentricity * Math.sin(d3);
            double d5 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d4) / (1.0 + d4), d2)) - d3;
            d3 += d5;
            if (!(Math.abs(d5) <= 1.0E-10)) continue;
            return d3;
        }
        throw new ProjectionException(129);
    }

    final double msfn(double d, double d2) {
        return d2 / Math.sqrt(1.0 - d * d * this.excentricitySquared);
    }

    final double tsfn(double d, double d2) {
        return Math.tan(0.5 * (1.5707963267948966 - d)) / Math.pow((1.0 - (d2 *= this.excentricity)) / (1.0 + d2), 0.5 * this.excentricity);
    }

    protected final double mlfn(double d, double d2, double d3) {
        d3 *= d2;
        d2 *= d2;
        return this.en0 * d - d3 * (this.en1 + d2 * (this.en2 + d2 * (this.en3 + d2 * this.en4)));
    }

    protected final double inv_mlfn(double d) throws ProjectionException {
        double d2;
        double d3 = 1.0 / (1.0 - this.excentricitySquared);
        double d4 = d;
        int n = 15;
        do {
            if (--n < 0) {
                throw new ProjectionException(Errors.format(129));
            }
            double d5 = Math.sin(d4);
            d2 = 1.0 - this.excentricitySquared * d5 * d5;
            d2 = (this.mlfn(d4, d5, Math.cos(d4)) - d) * (d2 * Math.sqrt(d2)) * d3;
            d4 -= d2;
        } while (!(Math.abs(d2) < 1.0E-11));
        return d4;
    }

    public static abstract class AbstractProvider
    extends MathTransformProvider {
        private static final long serialVersionUID = 6280666068007678702L;
        public static final ParameterDescriptor SEMI_MAJOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier(Citations.EPSG, "semi-major axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor SEMI_MINOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier(Citations.EPSG, "semi-minor axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor CENTRAL_MERIDIAN = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "central_meridian"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Longitude of false origin"), new NamedIdentifier(Citations.EPSG, "Longitude of origin"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "longitude_of_center"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "longitude_of_origin"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LATITUDE_OF_ORIGIN = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_origin"), new NamedIdentifier(Citations.EPSG, "Latitude of false origin"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "latitude_of_origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "latitude_of_center"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_1 = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1"), new NamedIdentifier(Citations.ESRI, "standard_parallel_1"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel1")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_2 = AbstractProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_2"), new NamedIdentifier(Citations.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_2"), new NamedIdentifier(Citations.ESRI, "standard_parallel_2"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel2")}, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor SCALE_FACTOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "scale_factor"), new NamedIdentifier(Citations.EPSG, "Scale factor at natural origin"), new NamedIdentifier(Citations.EPSG, "Scale factor on initial line"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtCenter"), new NamedIdentifier(Citations.ESRI, "Scale_Factor"), new NamedIdentifier(Citations.ESRI, "scale_factor")}, 1.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE);
        public static final ParameterDescriptor FALSE_EASTING = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_easting"), new NamedIdentifier(Citations.EPSG, "False easting"), new NamedIdentifier(Citations.EPSG, "Easting at false origin"), new NamedIdentifier(Citations.EPSG, "Easting at projection centre"), new NamedIdentifier(Citations.GEOTIFF, "FalseEasting"), new NamedIdentifier(Citations.ESRI, "false_easting")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor FALSE_NORTHING = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_northing"), new NamedIdentifier(Citations.EPSG, "False northing"), new NamedIdentifier(Citations.EPSG, "Northing at false origin"), new NamedIdentifier(Citations.EPSG, "Northing at projection centre"), new NamedIdentifier(Citations.GEOTIFF, "FalseNorthing"), new NamedIdentifier(Citations.ESRI, "False_Northing"), new NamedIdentifier(Citations.ESRI, "false_northing")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);

        public AbstractProvider(ParameterDescriptorGroup parameterDescriptorGroup) {
            super(2, 2, parameterDescriptorGroup);
        }

        public Class<? extends Projection> getOperationType() {
            return Projection.class;
        }

        static boolean isSpherical(ParameterValueGroup parameterValueGroup) {
            try {
                return MathTransformProvider.doubleValue(SEMI_MAJOR, parameterValueGroup) == MathTransformProvider.doubleValue(SEMI_MINOR, parameterValueGroup);
            }
            catch (IllegalStateException illegalStateException) {
                return false;
            }
        }

        protected static double doubleValue(ParameterDescriptor parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            double d = MathTransformProvider.doubleValue(parameterDescriptor, parameterValueGroup);
            if (NonSI.DEGREE_ANGLE.equals(parameterDescriptor.getUnit())) {
                d = Math.toRadians(d);
            }
            return d;
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        private static final long serialVersionUID = -9138242780765956870L;

        public Inverse() {
            super(MapProjection.this);
        }

        @Override
        public final Point2D transform(Point2D point2D, Point2D point2D2) throws ProjectionException {
            double d = point2D.getX();
            double d2 = point2D.getY();
            point2D2 = MapProjection.this.inverseTransformNormalized((d - MapProjection.this.falseEasting) / MapProjection.this.globalScale, (d2 - MapProjection.this.falseNorthing) / MapProjection.this.globalScale, point2D2);
            double d3 = Math.toDegrees(MapProjection.this.centralMeridian != 0.0 ? Inverse.rollLongitude(point2D2.getX() + MapProjection.this.centralMeridian) : point2D2.getX());
            double d4 = Math.toDegrees(point2D2.getY());
            point2D2.setLocation(d3, d4);
            if (MapProjection.this.verifyCoordinateRanges() && MapProjection.verifyGeographicRanges(this, d3, d4)) {
                MapProjection.this.warningLogged();
            }
            assert (MapProjection.this.checkReciprocal(point2D2, point2D != point2D2 ? point2D : new Point2D.Double(d, d2), false));
            return point2D2;
        }

        @Override
        public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            boolean bl;
            boolean bl2 = bl = dArray == dArray2 && n < n2 && n + 2 * n3 > n2;
            if (bl) {
                n += 2 * n3;
                n2 += 2 * n3;
            }
            Point2D.Double double_ = new Point2D.Double();
            ProjectionException projectionException = null;
            while (--n3 >= 0) {
                block5: {
                    try {
                        double_.x = dArray[n++];
                        double_.y = dArray[n++];
                        this.transform(double_, double_);
                        dArray2[n2++] = double_.x;
                        dArray2[n2++] = double_.y;
                    }
                    catch (ProjectionException projectionException2) {
                        dArray2[n2++] = Double.NaN;
                        dArray2[n2++] = Double.NaN;
                        if (projectionException != null) break block5;
                        projectionException = projectionException2;
                    }
                }
                if (!bl) continue;
                n -= 4;
                n2 -= 4;
            }
            if (projectionException != null) {
                throw projectionException;
            }
        }

        @Override
        public final void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws ProjectionException {
            boolean bl;
            boolean bl2 = bl = fArray == fArray2 && n < n2 && n + 2 * n3 > n2;
            if (bl) {
                n += 2 * n3;
                n2 += 2 * n3;
            }
            Point2D.Double double_ = new Point2D.Double();
            ProjectionException projectionException = null;
            while (--n3 >= 0) {
                block5: {
                    try {
                        double_.x = fArray[n++];
                        double_.y = fArray[n++];
                        this.transform(double_, double_);
                        fArray2[n2++] = (float)double_.x;
                        fArray2[n2++] = (float)double_.y;
                    }
                    catch (ProjectionException projectionException2) {
                        fArray2[n2++] = Float.NaN;
                        fArray2[n2++] = Float.NaN;
                        if (projectionException != null) break block5;
                        projectionException = projectionException2;
                    }
                }
                if (!bl) continue;
                n -= 4;
                n2 -= 4;
            }
            if (projectionException != null) {
                throw projectionException;
            }
        }

        @Override
        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }
    }

    private static final class CheckPoint
    extends Point2D.Double {
        public CheckPoint(Point2D point2D) {
            super(point2D.getX(), point2D.getY());
        }
    }
}

