/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.Utilities;
import org.geotools.util.WeakValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public class NamedIdentifier
implements ReferenceIdentifier,
GenericName,
Serializable {
    private static final long serialVersionUID = 8474731565582774497L;
    private static Map<CharSequence, GenericName> SCOPES;
    private final String code;
    private final String codespace;
    private final Citation authority;
    private final String version;
    private final InternationalString remarks;
    private GenericName name;

    public NamedIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        this(map, true);
    }

    public NamedIdentifier(Citation citation, InternationalString internationalString) {
        this(citation, internationalString.toString(null));
        this.name = this.getName(citation, internationalString);
    }

    public NamedIdentifier(Citation citation, String string) {
        this(citation, string, null);
    }

    public NamedIdentifier(Citation citation, String string, String string2) {
        this(NamedIdentifier.toMap(citation, string, string2));
    }

    private static Map<String, ?> toMap(Citation citation, String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        if (citation != null) {
            hashMap.put("authority", citation);
        }
        if (string != null) {
            hashMap.put("code", string);
        }
        if (string2 != null) {
            hashMap.put("version", string2);
        }
        return hashMap;
    }

    NamedIdentifier(Map<String, ?> map, boolean bl) throws IllegalArgumentException {
        NamedIdentifier.ensureNonNull("properties", map);
        Object object2 = null;
        String string = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        GrowableInternationalString growableInternationalString = null;
        String string2 = null;
        Object object6 = null;
        block10: for (Map.Entry<String, ?> object7 : map.entrySet()) {
            string2 = object7.getKey().trim().toLowerCase();
            object6 = object7.getValue();
            switch (string2.hashCode()) {
                case 3373707: {
                    if (bl || !string2.equals("name")) break;
                    object2 = object6;
                    continue block10;
                }
                case 3059181: {
                    if (!string2.equals("code")) break;
                    object2 = object6;
                    continue block10;
                }
                case -1108676807: {
                    if (!string2.equals("codespace")) break;
                    string = object6;
                    continue block10;
                }
                case 351608024: {
                    if (!string2.equals("version")) break;
                    object3 = object6;
                    continue block10;
                }
                case 1475610435: {
                    if (!string2.equals("authority")) break;
                    if (object6 instanceof String) {
                        object6 = Citations.fromName(object6.toString());
                    }
                    object4 = object6;
                    continue block10;
                }
                case 1091415283: {
                    if (!bl || !string2.equals("remarks") || !(object6 instanceof InternationalString)) break;
                    object5 = object6;
                    continue block10;
                }
            }
            if (!bl || !(object6 instanceof String)) continue;
            if (growableInternationalString == null) {
                growableInternationalString = object5 instanceof GrowableInternationalString ? (GrowableInternationalString)object5 : new GrowableInternationalString();
            }
            growableInternationalString.add("remarks", string2, object6.toString());
        }
        if (growableInternationalString != null && !growableInternationalString.getLocales().isEmpty()) {
            if (object5 == null) {
                object5 = growableInternationalString;
            } else {
                Logger logger = Logging.getLogger(NamedIdentifier.class);
                LogRecord logRecord = Loggings.format(Level.WARNING, 28);
                logRecord.setLoggerName(logger.getName());
                logger.log(logRecord);
            }
        }
        if (string == null && object4 instanceof Citation) {
            string = NamedIdentifier.getCodeSpace((Citation)object4);
        }
        try {
            string2 = "code";
            object6 = object2;
            this.code = (String)object6;
            string2 = "version";
            object6 = object3;
            this.version = (String)object6;
            string2 = "codespace";
            object6 = string;
            this.codespace = object6;
            string2 = "authority";
            object6 = object4;
            this.authority = (Citation)object6;
            string2 = "remarks";
            object6 = object5;
            this.remarks = (InternationalString)object6;
        }
        catch (ClassCastException classCastException) {
            InvalidParameterValueException invalidParameterValueException = new InvalidParameterValueException(Errors.format(58, string2, object6), string2, object6);
            invalidParameterValueException.initCause(classCastException);
            throw invalidParameterValueException;
        }
        NamedIdentifier.ensureNonNull("code", object2);
    }

    private static void ensureNonNull(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format(143, string), string, object);
        }
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getCodeSpace() {
        return this.codespace;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = this.getName(this.authority, this.code);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericName getName(Citation citation, CharSequence charSequence) {
        if (citation == null) {
            return new LocalName(charSequence);
        }
        CharSequence charSequence2 = this.codespace != null ? this.codespace : NamedIdentifier.getShortestTitle(citation);
        Class<NamedIdentifier> clazz = NamedIdentifier.class;
        synchronized (NamedIdentifier.class) {
            GenericName genericName;
            if (SCOPES == null) {
                SCOPES = new WeakValueHashMap<CharSequence, GenericName>();
            }
            if ((genericName = SCOPES.get(charSequence2)) == null) {
                genericName = new LocalName(charSequence2);
                SCOPES.put(charSequence2, genericName);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return new ScopedName(genericName, charSequence);
        }
    }

    private static InternationalString getShortestTitle(Citation citation) {
        InternationalString internationalString = citation.getTitle();
        int n = internationalString.length();
        Collection<? extends InternationalString> collection = citation.getAlternateTitles();
        if (collection != null) {
            for (InternationalString internationalString2 : collection) {
                int n2 = internationalString2.length();
                if (n2 <= 0 || n2 >= n) continue;
                internationalString = internationalString2;
                n = n2;
            }
        }
        return internationalString;
    }

    private static String getCodeSpace(Citation citation) {
        Object object;
        Collection<? extends Identifier> collection = citation.getIdentifiers();
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Identifier identifier = (Identifier)object.next();
                String string = identifier.getCode();
                if (!NamedIdentifier.isValidCodeSpace(string)) continue;
                return string;
            }
        }
        if (NamedIdentifier.isValidCodeSpace((String)(object = NamedIdentifier.getShortestTitle(citation).toString(null)))) {
            return object;
        }
        return null;
    }

    private static boolean isValidCodeSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        while (--n >= 0) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public org.opengis.util.LocalName head() {
        return this.getName().head();
    }

    @Override
    public org.opengis.util.LocalName tip() {
        return this.getName().tip();
    }

    @Override
    public NameSpace scope() {
        return this.getName().scope();
    }

    @Override
    public int depth() {
        return this.getName().depth();
    }

    public List<org.opengis.util.LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    @Override
    public org.opengis.util.ScopedName push(GenericName genericName) {
        return this.getName().push(genericName);
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Override
    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    @Override
    public String toString() {
        return ((Object)this.getName()).toString();
    }

    @Override
    public int compareTo(GenericName genericName) {
        return this.getName().compareTo(genericName);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            NamedIdentifier namedIdentifier = (NamedIdentifier)object;
            return Utilities.equals(this.code, namedIdentifier.code) && Utilities.equals(this.codespace, namedIdentifier.codespace) && Utilities.equals(this.version, namedIdentifier.version) && Utilities.equals(this.authority, namedIdentifier.authority) && Utilities.equals(this.remarks, namedIdentifier.remarks);
        }
        return false;
    }

    public int hashCode() {
        int n = 895086817;
        if (this.code != null) {
            n ^= this.code.hashCode();
        }
        if (this.version != null) {
            n = n * 37 + this.version.hashCode();
        }
        return n;
    }
}

