/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.geotools.metadata.ModifiableMetadata;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.annotation.UML;
import org.opengis.util.InternationalString;

final class PropertyAccessor {
    private static final Locale LOCALE = Locale.US;
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String[] EXCLUDES = new String[]{"clone", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"};
    private static final Map<Class<?>, Method[]> SHARED_GETTERS = new HashMap();
    final Class<?> type;
    final Class<?> implementation;
    private final Method[] getters;
    private final Method[] setters;
    private final Map<String, Integer> mapping;

    PropertyAccessor(Class<?> clazz, Class<?> clazz2) {
        this.implementation = clazz;
        this.type = clazz2;
        assert (clazz2.isAssignableFrom(clazz)) : clazz;
        this.getters = PropertyAccessor.getGetters(clazz2);
        this.mapping = new HashMap<String, Integer>(this.getters.length + (this.getters.length + 3) / 4);
        Method[] methodArray = null;
        Class[] classArray = new Class[1];
        for (int i = 0; i < this.getters.length; ++i) {
            Method method;
            Class<?> clazz3;
            Integer n = i;
            Method method2 = this.getters[i];
            String string = method2.getName();
            int n2 = PropertyAccessor.prefix(string).length();
            this.addMapping(string.substring(n2), n);
            UML uML = method2.getAnnotation(UML.class);
            if (uML != null) {
                this.addMapping(uML.identifier(), n);
            }
            classArray[0] = clazz3 = method2.getReturnType();
            if (string.length() > n2) {
                char c;
                char c2 = string.charAt(n2);
                string = c2 != (c = Character.toUpperCase(c2)) ? SET + c + string.substring(n2 + 1) : SET + string.substring(n2);
            }
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method2 = clazz.getMethod(method2.getName(), null);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new AssertionError((Object)noSuchMethodException2);
                }
                Class<?> clazz4 = clazz3;
                clazz3 = method2.getReturnType();
                if (clazz4.equals(clazz3)) continue;
                classArray[0] = clazz3;
                try {
                    method = clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    continue;
                }
            }
            if (methodArray == null) {
                methodArray = new Method[this.getters.length];
            }
            methodArray[i] = method;
        }
        this.setters = methodArray;
    }

    private void addMapping(String string, Integer n) throws IllegalArgumentException {
        String string2;
        Integer n2;
        if ((string = string.trim()).length() != 0 && (n2 = this.mapping.put(string2 = string.toLowerCase(LOCALE), n)) != null && !n2.equals(n)) {
            throw new IllegalArgumentException(Errors.format(154, string, n, string2, n2));
        }
    }

    static Class<?> getType(Class<?> clazz, String string) {
        if (clazz != null && !clazz.isInterface()) {
            Class clazz2;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            do {
                PropertyAccessor.getInterfaces(clazz, string, linkedHashSet);
            } while ((clazz = clazz.getSuperclass()) != null);
            Iterator iterator = linkedHashSet.iterator();
            block1: while (iterator.hasNext()) {
                clazz2 = (Class)iterator.next();
                for (Class clazz3 : linkedHashSet) {
                    if (clazz2 == clazz3 || !clazz2.isAssignableFrom(clazz3)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            iterator = linkedHashSet.iterator();
            if (iterator.hasNext()) {
                clazz2 = (Class)iterator.next();
                if (!iterator.hasNext()) {
                    return clazz2;
                }
            }
        }
        return null;
    }

    private static void getInterfaces(Class<?> clazz, String string, Collection<Class<?>> collection) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (clazz2.getName().startsWith(string)) {
                collection.add(clazz2);
            }
            PropertyAccessor.getInterfaces(clazz2, string, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method[] getGetters(Class<?> clazz) {
        Map<Class<?>, Method[]> map = SHARED_GETTERS;
        synchronized (map) {
            Method[] methodArray = SHARED_GETTERS.get(clazz);
            if (methodArray == null) {
                methodArray = clazz.getMethods();
                int n = 0;
                for (int i = 0; i < methodArray.length; ++i) {
                    String string;
                    Method method = methodArray[i];
                    if (method.getAnnotation(Deprecated.class) != null || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || (string = method.getName()).startsWith(SET) || PropertyAccessor.isExcluded(string)) continue;
                    methodArray[n++] = method;
                }
                methodArray = XArray.resize(methodArray, n);
                SHARED_GETTERS.put(clazz, methodArray);
            }
            return methodArray;
        }
    }

    private static boolean isExcluded(String string) {
        for (int i = 0; i < EXCLUDES.length; ++i) {
            if (!string.equals(EXCLUDES[i])) continue;
            return true;
        }
        return false;
    }

    private static String prefix(String string) {
        if (string.startsWith(GET)) {
            return GET;
        }
        if (string.startsWith(IS)) {
            return IS;
        }
        if (string.startsWith(SET)) {
            return SET;
        }
        return "";
    }

    final int count() {
        return this.getters.length;
    }

    final int indexOf(String string) {
        Integer n = this.mapping.get(string = string.trim().toLowerCase(LOCALE));
        return n != null ? n : -1;
    }

    final int requiredIndexOf(String string) throws IllegalArgumentException {
        Integer n = this.mapping.get((string = string.trim()).toLowerCase(LOCALE));
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException(Errors.format(185, string));
    }

    private static boolean isAcronym(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isLowerCase(string.charAt(n++))) continue;
            return false;
        }
        return true;
    }

    final String name(int n) {
        if (n >= 0 && n < this.getters.length) {
            String string = this.getters[n].getName();
            int n2 = PropertyAccessor.prefix(string).length();
            if (string.length() > n2) {
                char c;
                char c2;
                string = PropertyAccessor.isAcronym(string, n2) ? string.substring(n2) : ((c2 = string.charAt(n2)) != (c = Character.toLowerCase(c2)) ? c + string.substring(n2 + 1) : string.substring(n2));
            }
            return string;
        }
        return null;
    }

    final Object get(int n, Object object) {
        return n >= 0 && n < this.getters.length ? PropertyAccessor.get(this.getters[n], object) : null;
    }

    private static Object get(Method method, Object object) {
        assert (!method.getReturnType().equals(Void.TYPE)) : method;
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }

    final Object set(int n, Object object, Object object2) throws IllegalArgumentException, ClassCastException {
        String string;
        if (n >= 0 && n < this.getters.length && this.setters != null) {
            Method method = this.getters[n];
            Method method2 = this.setters[n];
            if (method2 != null) {
                Object object3 = PropertyAccessor.get(method, object);
                PropertyAccessor.set(method, method2, object, new Object[]{object2});
                return object3;
            }
            string = method.getName();
            string = string.substring(PropertyAccessor.prefix(string).length());
        } else {
            string = String.valueOf(n);
        }
        throw new IllegalArgumentException(Errors.format(57, string));
    }

    private static void set(Method method, Method method2, Object object, Object[] objectArray) throws ClassCastException {
        Object object2;
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Object object3;
            Class<?> clazz;
            Object object4;
            Collection collection;
            Class<?> clazz2;
            object2 = objectArray[i];
            if (object2 == null || Classes.primitiveToWrapper(clazz2 = classArray[i]).isInstance(object2)) continue;
            if (Collection.class.isAssignableFrom(clazz2) && !(object2 instanceof Collection)) {
                collection = (Collection)PropertyAccessor.get(method, object);
                if (collection instanceof CheckedCollection) {
                    object4 = ((CheckedCollection)collection).getElementType();
                } else {
                    clazz = Classes.boundOfParameterizedAttribute(method2);
                    if (clazz == null && (clazz = Classes.boundOfParameterizedAttribute(method)) == null) {
                        clazz = Object.class;
                    }
                    object4 = clazz;
                }
            } else {
                collection = null;
                object4 = clazz2;
            }
            clazz = null;
            Exception exception = null;
            if (((Class)object4).isInstance(object2)) {
                clazz = object2;
            } else if (object2 instanceof CharSequence) {
                object3 = object2.toString();
                if (InternationalString.class.isAssignableFrom((Class<?>)object4)) {
                    clazz = new SimpleInternationalString((String)object3);
                } else if (File.class.isAssignableFrom((Class<?>)object4)) {
                    clazz = new File((String)object3);
                } else if (URL.class.isAssignableFrom((Class<?>)object4)) {
                    try {
                        clazz = new URL((String)object3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        exception = malformedURLException;
                    }
                } else if (URI.class.isAssignableFrom((Class<?>)object4)) {
                    try {
                        clazz = new URI((String)object3);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        exception = uRISyntaxException;
                    }
                } else {
                    try {
                        clazz = Classes.valueOf(object4, (String)object3);
                    }
                    catch (RuntimeException runtimeException) {
                        exception = runtimeException;
                    }
                }
            }
            if (clazz == null) {
                object3 = new ClassCastException(Errors.format(61, object2.getClass(), object4));
                ((Throwable)object3).initCause(exception);
                throw object3;
            }
            if (collection != null) {
                PropertyAccessor.addUnsafe(collection, clazz);
                clazz = collection;
            }
            objectArray[i] = clazz;
        }
        try {
            method2.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = invocationTargetException.getTargetException();
            if (object2 instanceof RuntimeException) {
                throw (RuntimeException)object2;
            }
            if (object2 instanceof Error) {
                throw (Error)object2;
            }
            throw new UndeclaredThrowableException((Throwable)object2);
        }
    }

    private static void addUnsafe(Collection<?> collection, Object object) {
        collection.add(object);
    }

    public boolean shallowEquals(Object object, Object object2, boolean bl) {
        assert (this.type.isInstance(object)) : object;
        assert (this.type.isInstance(object2)) : object2;
        for (int i = 0; i < this.getters.length; ++i) {
            Method method = this.getters[i];
            Object object3 = PropertyAccessor.get(method, object);
            Object object4 = PropertyAccessor.get(method, object2);
            boolean bl2 = PropertyAccessor.isEmpty(object3);
            boolean bl3 = PropertyAccessor.isEmpty(object4);
            if (bl2 && bl3 || Utilities.equals(object3, object4) || bl && (bl2 || bl3)) continue;
            return false;
        }
        return true;
    }

    public boolean shallowCopy(Object object, Object object2, boolean bl) throws UnmodifiableMetadataException {
        boolean bl2 = true;
        assert (this.type.isInstance(object)) : object;
        assert (this.implementation.isInstance(object2)) : object2;
        Object[] objectArray = new Object[1];
        for (int i = 0; i < this.getters.length; ++i) {
            Method method = this.getters[i];
            objectArray[0] = PropertyAccessor.get(method, object);
            if (bl && PropertyAccessor.isEmpty(objectArray[0])) continue;
            if (this.setters == null) {
                return false;
            }
            Method method2 = this.setters[i];
            if (method2 != null) {
                PropertyAccessor.set(method, method2, object2, objectArray);
                continue;
            }
            bl2 = false;
        }
        return bl2;
    }

    final void freeze(Object object) {
        assert (this.implementation.isInstance(object)) : object;
        if (this.setters != null) {
            Object[] objectArray = new Object[1];
            for (int i = 0; i < this.getters.length; ++i) {
                Object object2;
                Method method;
                Object object3;
                Method method2 = this.setters[i];
                if (method2 == null || (object3 = PropertyAccessor.get(method = this.getters[i], object)) == (object2 = ModifiableMetadata.unmodifiable(object3))) continue;
                objectArray[0] = object2;
                PropertyAccessor.set(method, method2, object, objectArray);
            }
        }
    }

    final boolean isModifiable() {
        if (this.setters != null) {
            return true;
        }
        for (int i = 0; i < this.getters.length; ++i) {
            if (!Cloneable.class.isAssignableFrom(this.getters[i].getReturnType())) continue;
            return true;
        }
        return false;
    }

    public int hashCode(Object object) {
        assert (this.type.isInstance(object)) : object;
        int n = 0;
        for (int i = 0; i < this.getters.length; ++i) {
            Object object2 = PropertyAccessor.get(this.getters[i], object);
            if (PropertyAccessor.isEmpty(object2)) continue;
            n += object2.hashCode();
        }
        return n;
    }

    public int count(Object object, int n) {
        assert (this.type.isInstance(object)) : object;
        int n2 = 0;
        for (int i = 0; i < this.getters.length && (PropertyAccessor.isEmpty(PropertyAccessor.get(this.getters[i], object)) || ++n2 < n); ++i) {
        }
        return n2;
    }

    static boolean isEmpty(Object object) {
        return object == null || object instanceof Collection && ((Collection)object).isEmpty() || object instanceof CharSequence && object.toString().trim().length() == 0 || object.getClass().isArray() && Array.getLength(object) == 0;
    }
}

