/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExtractBoundsFilterVisitor
extends NullFilterVisitor {
    public static NullFilterVisitor BOUNDS_VISITOR = new ExtractBoundsFilterVisitor();
    private static Logger LOGGER = Logging.getLogger("org.geotools.index.rtree");

    protected ExtractBoundsFilterVisitor() {
    }

    private ReferencedEnvelope bbox(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)object;
        }
        if (object instanceof Envelope) {
            return new ReferencedEnvelope((Envelope)object, null);
        }
        if (object instanceof CoordinateReferenceSystem) {
            return new ReferencedEnvelope((CoordinateReferenceSystem)object);
        }
        throw new ClassCastException("Could not cast data to ReferencedEnvelope");
    }

    @Override
    public Object visit(ExcludeFilter excludeFilter, Object object) {
        return new Envelope();
    }

    @Override
    public Object visit(IncludeFilter includeFilter, Object object) {
        return this.infinity();
    }

    Envelope infinity() {
        return new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Object visit(Literal literal, Object object) {
        ReferencedEnvelope referencedEnvelope = this.bbox(object);
        Object object2 = literal.getValue();
        if (object2 instanceof Geometry) {
            Geometry geometry = (Geometry)object2;
            Envelope envelope = geometry.getEnvelopeInternal();
            if (referencedEnvelope != null) {
                referencedEnvelope.expandToInclude(envelope);
                return referencedEnvelope;
            }
            return this.bbox(envelope);
        }
        LOGGER.finer("LiteralExpression ignored!");
        return referencedEnvelope;
    }

    @Override
    public Object visit(And and, Object object) {
        Envelope envelope = this.infinity();
        for (Filter filter : and.getChildren()) {
            Envelope envelope2 = (Envelope)filter.accept(this, object);
            envelope = envelope.intersection(envelope2);
        }
        return envelope;
    }

    @Override
    public Object visit(Not not, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(Or or, Object object) {
        Envelope envelope = new Envelope();
        for (Filter filter : or.getChildren()) {
            Envelope envelope2 = (Envelope)filter.accept(this, object);
            envelope.expandToInclude(envelope2);
        }
        return envelope;
    }

    @Override
    public Object visit(Add add, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(Divide divide, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(Function function, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(Id id, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(Multiply multiply, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(NilExpression nilExpression, Object object) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyName propertyName, Object object) {
        return null;
    }

    @Override
    public Object visit(Subtract subtract, Object object) {
        return this.infinity();
    }

    @Override
    public Object visitNullFilter(Object object) {
        return this.infinity();
    }
}

