/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.FunctionImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class DefaultFunctionFactory
implements FunctionFactory {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter");
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private Map<String, FunctionDescriptor> functionCache;

    @Override
    public List<FunctionName> getFunctionNames() {
        ArrayList<FunctionName> arrayList = new ArrayList<FunctionName>(this.functionCache().size());
        for (FunctionDescriptor functionDescriptor : this.functionCache().values()) {
            arrayList.add(functionDescriptor.name);
        }
        return arrayList;
    }

    @Override
    public Function function(String string, List<Expression> list, Literal literal) {
        FunctionDescriptor functionDescriptor = this.functionCache().get(this.functionName(string));
        if (functionDescriptor == null) {
            return null;
        }
        try {
            return functionDescriptor.newFunction(list, literal);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINER, "Unable to create function " + string + "Function", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FunctionDescriptor> functionCache() {
        if (this.functionCache == null) {
            DefaultFunctionFactory defaultFunctionFactory = this;
            synchronized (defaultFunctionFactory) {
                if (this.functionCache == null) {
                    this.loadFunctions();
                }
            }
        }
        return this.functionCache;
    }

    private void loadFunctions() {
        this.functionCache = new HashMap<String, FunctionDescriptor>();
        Set set = CommonFactoryFinder.getFunctionExpressions(null);
        for (Function function : set) {
            FunctionDescriptor functionDescriptor = new FunctionDescriptor(this.filterFactory.functionName(function.getName(), function.getArgCount()), function.getClass());
            this.functionCache.put(this.functionName(function.getName()), functionDescriptor);
        }
        set = CommonFactoryFinder.getFunctions(null);
        for (Function function : set) {
            int n = function instanceof FunctionExpression ? ((FunctionExpression)function).getArgCount() : function.getParameters().size();
            FunctionDescriptor functionDescriptor = new FunctionDescriptor(this.filterFactory.functionName(function.getName(), n), function.getClass());
            this.functionCache.put(this.functionName(function.getName()), functionDescriptor);
        }
    }

    private String functionName(String string) {
        int n = -1;
        n = string.indexOf("Function");
        if (n != -1) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase().trim();
        return string;
    }

    static class FunctionDescriptor {
        FunctionName name;
        Class clazz;

        FunctionDescriptor(FunctionName functionName, Class clazz) {
            this.name = functionName;
            this.clazz = clazz;
        }

        Function newFunction(List<Expression> list, Literal literal) throws Exception {
            if (FunctionExpression.class.isAssignableFrom(this.clazz)) {
                FunctionExpression functionExpression = (FunctionExpression)this.clazz.newInstance();
                if (list != null) {
                    functionExpression.setParameters(list);
                }
                return functionExpression;
            }
            if (FunctionImpl.class.isAssignableFrom(this.clazz)) {
                FunctionImpl functionImpl = (FunctionImpl)this.clazz.newInstance();
                if (list != null) {
                    functionImpl.setParameters(list);
                }
                if (literal != null) {
                    functionImpl.setFallbackValue(literal);
                }
                return functionImpl;
            }
            Constructor constructor = this.clazz.getConstructor(List.class, Literal.class);
            return (Function)constructor.newInstance(list, literal);
        }
    }
}

