/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.DirectPropertyAccessorFactory;
import org.geotools.filter.expression.NullPropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;

public class PropertyAccessors {
    static final PropertyAccessorFactory[] FACTORY_CACHE;

    private PropertyAccessors() {
    }

    public static List<PropertyAccessor> findPropertyAccessors(Object object, String string, Class clazz, Hints hints) {
        if (object == null) {
            return null;
        }
        ArrayList<PropertyAccessor> arrayList = new ArrayList<PropertyAccessor>();
        for (PropertyAccessorFactory propertyAccessorFactory : FACTORY_CACHE) {
            PropertyAccessor propertyAccessor = propertyAccessorFactory.createPropertyAccessor(object.getClass(), string, clazz, hints);
            if (propertyAccessor == null || !propertyAccessor.canHandle(object, string, clazz)) continue;
            arrayList.add(propertyAccessor);
        }
        return arrayList;
    }

    static {
        ArrayList<PropertyAccessorFactory> arrayList = new ArrayList<PropertyAccessorFactory>();
        arrayList.add(new NullPropertyAccessorFactory());
        arrayList.add(new SimpleFeaturePropertyAccessorFactory());
        arrayList.add(new DirectPropertyAccessorFactory());
        Iterator<PropertyAccessorFactory> iterator = FactoryRegistry.lookupProviders(PropertyAccessorFactory.class);
        while (iterator.hasNext()) {
            PropertyAccessorFactory propertyAccessorFactory = iterator.next();
            if (propertyAccessorFactory instanceof SimpleFeaturePropertyAccessorFactory || propertyAccessorFactory instanceof DirectPropertyAccessorFactory || propertyAccessorFactory instanceof NullPropertyAccessorFactory) continue;
            arrayList.add(propertyAccessorFactory);
        }
        FACTORY_CACHE = arrayList.toArray(new PropertyAccessorFactory[arrayList.size()]);
    }
}

