/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigDecimal;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;

public class LiteralExpressionImpl
extends DefaultExpression
implements LiteralExpression {
    private static BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private Object literal = null;
    private Object parsedValue = null;

    protected LiteralExpressionImpl() {
    }

    protected LiteralExpressionImpl(Object object) throws IllegalFilterException {
        this.setLiteral(object);
    }

    protected LiteralExpressionImpl(int n) {
        try {
            this.setLiteral(new Integer(n));
        }
        catch (IllegalFilterException illegalFilterException) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Integers");
        }
    }

    @Override
    public short getType() {
        return this.expressionType;
    }

    @Override
    public final void setLiteral(Object object) throws IllegalFilterException {
        this.setValue(object);
    }

    @Override
    public Object getValue() {
        return this.literal;
    }

    public final void setValue(Object object) {
        this.expressionType = object instanceof Double ? (short)101 : (object instanceof Integer ? (short)102 : (object instanceof Long ? (short)99 : (object instanceof String ? (short)103 : (object instanceof Geometry ? (short)104 : (short)115))));
        this.literal = object;
    }

    @Override
    public Object evaluate(SimpleFeature simpleFeature) throws IllegalArgumentException {
        return this.evaluate((Object)simpleFeature);
    }

    @Override
    public Object evaluate(Object object) {
        if (this.parsedValue != null) {
            return this.parsedValue;
        }
        if (this.literal == null || !(this.literal instanceof String)) {
            this.parsedValue = this.literal;
        } else {
            String string = (String)this.literal;
            try {
                long l;
                double d;
                BigDecimal bigDecimal = new BigDecimal(string);
                this.parsedValue = bigDecimal.scale() > 0 ? (Number)(!Double.isInfinite(d = bigDecimal.doubleValue()) ? Double.valueOf(d) : bigDecimal) : (Number)(bigDecimal.compareTo(MIN_LONG) >= 0 && bigDecimal.compareTo(MAX_LONG) <= 0 ? ((long)((int)(l = bigDecimal.longValue())) == l ? (Number)new Integer((int)l) : (Number)new Long(l)) : bigDecimal.toBigInteger());
            }
            catch (Exception exception) {
                this.parsedValue = this.literal;
            }
        }
        return this.parsedValue;
    }

    @Override
    public Object evaluate(Object object, Class clazz) {
        return Converters.convert(this.literal, clazz);
    }

    public String toString() {
        return this.literal == null ? "NULL" : this.literal.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof LiteralExpressionImpl) {
            LiteralExpressionImpl literalExpressionImpl = (LiteralExpressionImpl)object;
            if (this.literal == null) {
                return literalExpressionImpl.literal == null;
            }
            if (this.expressionType == literalExpressionImpl.expressionType) {
                if (this.literal.equals(literalExpressionImpl.literal)) {
                    return true;
                }
                if (this.expressionType == 104 && this.literal instanceof Geometry && literalExpressionImpl.literal instanceof Geometry && ((Geometry)this.literal).equals((Geometry)literalExpressionImpl.literal)) {
                    return true;
                }
            }
            if (this.expressionType == 104) {
                return ((Geometry)this.literal).equals((Geometry)literalExpressionImpl.evaluate((Object)null, Geometry.class));
            }
            if (this.expressionType == 102) {
                return ((Integer)this.literal).equals(literalExpressionImpl.evaluate((Object)null, Integer.class));
            }
            if (this.expressionType == 103) {
                return ((String)this.literal).equals(literalExpressionImpl.evaluate((Object)null, String.class));
            }
            if (this.expressionType == 101) {
                return ((Double)this.literal).equals(literalExpressionImpl.evaluate((Object)null, Double.class));
            }
            if (this.expressionType == 99) {
                return ((Long)this.literal).equals(literalExpressionImpl.evaluate((Object)null, Long.class));
            }
            return true;
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            return this.equals(new LiteralExpressionImpl(literal.getValue()));
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.literal == null ? 0 : this.literal.hashCode());
        n = 37 * n + this.expressionType;
        return n;
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor, Object object) {
        return expressionVisitor.visit(this, object);
    }
}

