/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;

public abstract class GeometryFilterImpl
extends BinaryComparisonAbstract
implements GeometryFilter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter");

    protected GeometryFilterImpl(FilterFactory filterFactory, org.opengis.filter.expression.Expression expression, org.opengis.filter.expression.Expression expression2) {
        super(filterFactory, expression, expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setExpression1(org.opengis.filter.expression.Expression expression) {
        if (expression instanceof Expression) {
            Expression expression2 = (Expression)expression;
            if (!DefaultExpression.isGeometryExpression(expression2.getType()) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add (left) non-geometry expression to geometry filter.");
            super.setExpression1(expression2);
            return;
        } else {
            super.setExpression1(expression);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setExpression2(org.opengis.filter.expression.Expression expression) {
        if (expression instanceof Expression) {
            Expression expression2 = (Expression)expression;
            if (!DefaultExpression.isGeometryExpression(expression2.getType()) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add (right) non-geometryexpression to geometry filter.");
            super.setExpression2(expression2);
            return;
        } else {
            super.setExpression2(expression);
        }
    }

    protected Geometry getLeftGeometry(Object object) {
        org.opengis.filter.expression.Expression expression = this.getExpression1();
        if (expression != null) {
            Geometry geometry = expression.evaluate(object, Geometry.class);
            return geometry;
        }
        if (object instanceof SimpleFeature) {
            return (Geometry)((SimpleFeature)object).getDefaultGeometry();
        }
        return null;
    }

    protected Geometry getRightGeometry(Object object) {
        org.opengis.filter.expression.Expression expression = this.getExpression2();
        if (expression != null) {
            return expression.evaluate(object, Geometry.class);
        }
        if (object instanceof SimpleFeature) {
            return (Geometry)((SimpleFeature)object).getDefaultGeometry();
        }
        return null;
    }

    @Override
    public boolean evaluate(SimpleFeature simpleFeature) {
        return this.evaluate((Object)simpleFeature);
    }

    public String toString() {
        String string = null;
        if (this.filterType == 5) {
            string = " equals ";
        } else if (this.filterType == 6) {
            string = " disjoint ";
        } else if (this.filterType == 7) {
            string = " intersects ";
        } else if (this.filterType == 9) {
            string = " crosses ";
        } else if (this.filterType == 10) {
            string = " within ";
        } else if (this.filterType == 11) {
            string = " contains ";
        } else if (this.filterType == 12) {
            string = " overlaps ";
        } else if (this.filterType == 13) {
            string = " beyond ";
        } else if (this.filterType == 4) {
            string = " bbox ";
        }
        org.opengis.filter.expression.Expression expression = this.getExpression1();
        org.opengis.filter.expression.Expression expression2 = this.getExpression2();
        if (this.expression1 == null && expression2 == null) {
            return "[ null" + string + "null" + " ]";
        }
        if (expression == null) {
            return "[ null" + string + expression2.toString() + " ]";
        }
        if (expression2 == null) {
            return "[ " + expression.toString() + string + "null" + " ]";
        }
        return "[ " + expression.toString() + string + expression2.toString() + " ]";
    }

    public boolean equals(Object object) {
        if (object instanceof GeometryFilterImpl) {
            GeometryFilterImpl geometryFilterImpl = (GeometryFilterImpl)object;
            boolean bl = true;
            boolean bl2 = bl = geometryFilterImpl.getFilterType() == this.filterType;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("filter type match:" + bl + "; in:" + geometryFilterImpl.getFilterType() + "; out:" + this.filterType);
            }
            boolean bl3 = geometryFilterImpl.expression1 != null ? bl && geometryFilterImpl.expression1.equals(this.expression1) : (bl = bl && this.expression1 == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("left geom match:" + bl + "; in:" + geometryFilterImpl.expression1 + "; out:" + this.expression1);
            }
            boolean bl4 = geometryFilterImpl.expression2 != null ? bl && geometryFilterImpl.expression2.equals(this.expression2) : (bl = bl && this.expression2 == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("right geom match:" + bl + "; in:" + geometryFilterImpl.expression2 + "; out:" + this.expression2);
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        org.opengis.filter.expression.Expression expression = this.getExpression1();
        org.opengis.filter.expression.Expression expression2 = this.getExpression2();
        int n = 17;
        n = 37 * n + this.filterType;
        n = 37 * n + (expression == null ? 0 : expression.hashCode());
        n = 37 * n + (expression2 == null ? 0 : expression2.hashCode());
        return n;
    }
}

