/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Geometry;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.Types;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.opengis.geometry.BoundingBox;

public class SimpleFeatureImpl
implements SimpleFeature {
    protected FeatureId id;
    protected SimpleFeatureType featureType;
    protected Object[] values;
    protected Map<String, Integer> index;
    protected Map<Object, Object> userData;
    protected Map<Object, Object>[] attributeUserData;
    protected boolean validating;

    public SimpleFeatureImpl(Object[] objectArray, SimpleFeatureType simpleFeatureType, FeatureId featureId, boolean bl) {
        this.id = featureId;
        this.featureType = simpleFeatureType;
        this.values = objectArray;
        this.validating = bl;
        this.index = simpleFeatureType instanceof SimpleFeatureTypeImpl ? ((SimpleFeatureTypeImpl)simpleFeatureType).index : SimpleFeatureTypeImpl.buildIndex(simpleFeatureType);
        if (bl) {
            this.validate();
        }
    }

    @Override
    public FeatureId getIdentifier() {
        return this.id;
    }

    @Override
    public String getID() {
        return this.id.getID();
    }

    @Override
    public Object getAttribute(int n) throws IndexOutOfBoundsException {
        return this.values[n];
    }

    @Override
    public Object getAttribute(String string) {
        Integer n = this.index.get(string);
        if (n != null) {
            return this.getAttribute(n);
        }
        return null;
    }

    @Override
    public Object getAttribute(Name name) {
        return this.getAttribute(name.getLocalPart());
    }

    @Override
    public List<Object> getAttributes() {
        return new ArrayList<Object>(Arrays.asList(this.values));
    }

    @Override
    public Object getDefaultGeometry() {
        GeometryDescriptor geometryDescriptor;
        Object object;
        Integer n = this.index.get(null);
        Object object2 = object = n != null ? this.getAttribute(n) : null;
        if (object == null && (geometryDescriptor = this.featureType.getGeometryDescriptor()) != null) {
            Integer n2 = this.index.get(geometryDescriptor.getName().getLocalPart());
            object = this.getAttribute(n2);
        }
        return object;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public SimpleFeatureType getType() {
        return this.featureType;
    }

    @Override
    public void setAttribute(int n, Object object) throws IndexOutOfBoundsException {
        Object obj = Converters.convert(object, this.getFeatureType().getDescriptor(n).getType().getBinding());
        if (this.validating) {
            Types.validate(this.featureType.getDescriptor(n), obj);
        }
        this.values[n] = obj;
    }

    @Override
    public void setAttribute(String string, Object object) {
        Integer n = this.index.get(string);
        if (n == null) {
            throw new IllegalAttributeException("Unknown attribute " + string);
        }
        this.setAttribute(n, object);
    }

    @Override
    public void setAttribute(Name name, Object object) {
        this.setAttribute(name.getLocalPart(), object);
    }

    @Override
    public void setAttributes(List<Object> list) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = list.get(i);
        }
    }

    @Override
    public BoundingBox getBounds() {
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(this.featureType.getCoordinateReferenceSystem());
        for (Object object : this.values) {
            if (!(object instanceof Geometry)) continue;
            Geometry geometry = (Geometry)object;
            if (referencedEnvelope.isNull()) {
                referencedEnvelope.init(geometry.getEnvelopeInternal());
                continue;
            }
            referencedEnvelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return referencedEnvelope;
    }

    @Override
    public GeometryAttribute getDefaultGeometryProperty() {
        GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
        GeometryAttributeImpl geometryAttributeImpl = null;
        if (geometryDescriptor != null) {
            Object object = this.getDefaultGeometry();
            geometryAttributeImpl = new GeometryAttributeImpl(object, geometryDescriptor, null);
        }
        return geometryAttributeImpl;
    }

    @Override
    public Collection<Property> getProperties() {
        return new AttributeList();
    }

    @Override
    public Property getProperty(Name name) {
        return this.getProperty(name.getLocalPart());
    }

    @Override
    public Property getProperty(String string) {
        Integer n = this.index.get(string);
        if (n == null) {
            return null;
        }
        int n2 = n;
        AttributeDescriptor attributeDescriptor = this.featureType.getDescriptor(n2);
        if (attributeDescriptor instanceof GeometryDescriptor) {
            return new GeometryAttributeImpl(this.values[n2], (GeometryDescriptor)attributeDescriptor, null);
        }
        return new Attribute(n2);
    }

    @Override
    public Collection<? extends Property> getValue() {
        return this.getProperties();
    }

    @Override
    public AttributeDescriptor getDescriptor() {
        return new AttributeDescriptorImpl(this.featureType, this.featureType.getName(), 0, Integer.MAX_VALUE, true, null);
    }

    @Override
    public Name getName() {
        return this.featureType.getName();
    }

    @Override
    public boolean isNillable() {
        return true;
    }

    @Override
    public Map<Object, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<Object, Object>();
        }
        return this.userData;
    }

    public int hashCode() {
        return this.id.hashCode() * this.featureType.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof SimpleFeatureImpl)) {
            return false;
        }
        SimpleFeatureImpl simpleFeatureImpl = (SimpleFeatureImpl)object;
        if (this.id == null && simpleFeatureImpl.getIdentifier() != null) {
            return false;
        }
        if (!this.id.equals(simpleFeatureImpl.getIdentifier())) {
            return false;
        }
        if (!simpleFeatureImpl.getFeatureType().equals(this.featureType)) {
            return false;
        }
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = simpleFeatureImpl.getAttribute(i);
            if (this.values[i] == null) {
                if (object2 == null) continue;
                return false;
            }
            if (this.values[i].equals(object2)) continue;
            if (this.values[i] instanceof Geometry && object2 instanceof Geometry) {
                if (((Geometry)this.values[i]).equals((Geometry)object2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
        for (int i = 0; i < this.values.length; ++i) {
            AttributeDescriptor attributeDescriptor = this.getType().getDescriptor(i);
            Types.validate(attributeDescriptor, this.values[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SimpleFeatureImpl:");
        stringBuffer.append(this.getType().getName().getLocalPart());
        stringBuffer.append("=");
        stringBuffer.append(this.getValue());
        return stringBuffer.toString();
    }

    class SimpleGeometryAttribute
    extends Attribute
    implements GeometryAttribute {
        SimpleGeometryAttribute(int n) {
            super(n);
        }

        @Override
        public GeometryType getType() {
            return (GeometryType)super.getType();
        }

        @Override
        public GeometryDescriptor getDescriptor() {
            return (GeometryDescriptor)super.getDescriptor();
        }

        @Override
        public BoundingBox getBounds() {
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(SimpleFeatureImpl.this.featureType.getCoordinateReferenceSystem());
            Object object = SimpleFeatureImpl.this.getAttribute(this.index);
            if (object instanceof Geometry) {
                referencedEnvelope.init(((Geometry)object).getEnvelopeInternal());
            }
            return referencedEnvelope;
        }

        @Override
        public int hashCode() {
            return 17 * super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SimpleGeometryAttribute)) {
                return false;
            }
            return super.equals(object);
        }
    }

    class Attribute
    implements org.opengis.feature.Attribute {
        int index;

        Attribute(int n) {
            this.index = n;
        }

        @Override
        public Identifier getIdentifier() {
            return null;
        }

        @Override
        public AttributeDescriptor getDescriptor() {
            return SimpleFeatureImpl.this.featureType.getDescriptor(this.index);
        }

        @Override
        public AttributeType getType() {
            return SimpleFeatureImpl.this.featureType.getType(this.index);
        }

        @Override
        public Name getName() {
            return this.getDescriptor().getName();
        }

        @Override
        public Map<Object, Object> getUserData() {
            if (SimpleFeatureImpl.this.attributeUserData == null) {
                SimpleFeatureImpl.this.attributeUserData = new HashMap[SimpleFeatureImpl.this.values.length];
            }
            if (SimpleFeatureImpl.this.attributeUserData[this.index] == null) {
                SimpleFeatureImpl.this.attributeUserData[this.index] = new HashMap<Object, Object>();
            }
            return SimpleFeatureImpl.this.attributeUserData[this.index];
        }

        @Override
        public Object getValue() {
            return SimpleFeatureImpl.this.values[this.index];
        }

        @Override
        public boolean isNillable() {
            return this.getDescriptor().isNillable();
        }

        public int hashCode() {
            return 37 * this.getDescriptor().hashCode() + 37 * (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            if (!Utilities.equals(this.getDescriptor(), attribute.getDescriptor())) {
                return false;
            }
            if (!Utilities.deepEquals(this.getValue(), attribute.getValue())) {
                return false;
            }
            return Utilities.equals(this.getIdentifier(), attribute.getIdentifier());
        }

        @Override
        public void validate() {
            Types.validate(this.getDescriptor(), SimpleFeatureImpl.this.values[this.index]);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("SimpleFeatureImpl.Attribute: ");
            stringBuffer.append(this.getDescriptor().getName().getLocalPart());
            if (!this.getDescriptor().getName().getLocalPart().equals(this.getDescriptor().getType().getName().getLocalPart()) || SimpleFeatureImpl.this.id != null) {
                stringBuffer.append("<");
                stringBuffer.append(this.getDescriptor().getType().getName().getLocalPart());
                if (SimpleFeatureImpl.this.id != null) {
                    stringBuffer.append(" id=");
                    stringBuffer.append(SimpleFeatureImpl.this.id);
                }
                stringBuffer.append(">");
            }
            stringBuffer.append("=");
            stringBuffer.append(SimpleFeatureImpl.this.values[this.index]);
            return stringBuffer.toString();
        }
    }

    class AttributeList
    extends AbstractList<Property> {
        AttributeList() {
        }

        @Override
        public Property get(int n) {
            AttributeDescriptor attributeDescriptor = SimpleFeatureImpl.this.featureType.getDescriptor(n);
            if (attributeDescriptor instanceof GeometryDescriptor) {
                return new SimpleGeometryAttribute(n);
            }
            return new Attribute(n);
        }

        @Override
        public Attribute set(int n, Property property) {
            SimpleFeatureImpl.this.values[n] = property.getValue();
            return null;
        }

        @Override
        public int size() {
            return SimpleFeatureImpl.this.values.length;
        }
    }
}

