/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class AbstractFeatureCollection
implements SimpleFeatureCollection {
    protected String id;
    protected SimpleFeatureType schema;
    protected final Set open = new HashSet();

    protected AbstractFeatureCollection(SimpleFeatureType simpleFeatureType) {
        this.id = this.id == null ? "featureCollection" : this.id;
        this.schema = simpleFeatureType;
    }

    @Override
    public SimpleFeatureIterator features() {
        DelegateSimpleFeatureIterator delegateSimpleFeatureIterator = new DelegateSimpleFeatureIterator(this, this.openIterator());
        this.getOpenIterators().add(delegateSimpleFeatureIterator);
        return delegateSimpleFeatureIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        try {
            this.closeIterator(iterator);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.open.remove(iterator);
        }
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> featureIterator) {
        if (featureIterator != null) {
            featureIterator.close();
        }
    }

    protected abstract Iterator<SimpleFeature> openIterator();

    protected abstract void closeIterator(Iterator<SimpleFeature> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Iterator iterator = this.open.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Iterator)) continue;
            Iterator iterator2 = (Iterator)e;
            try {
                this.closeIterator(iterator2);
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                iterator.remove();
            }
        }
    }

    @Override
    public abstract int size();

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        boolean bl = false;
        Iterator<? extends SimpleFeature> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl = true;
            }
        }
        finally {
            if (collection instanceof FeatureCollection) {
                FeatureCollection featureCollection = (FeatureCollection)((Object)collection);
                featureCollection.close(iterator);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> featureCollection) {
        boolean bl = false;
        FeatureIterator<? extends SimpleFeature> featureIterator = featureCollection.features();
        try {
            while (featureIterator.hasNext()) {
                if (!this.add(featureIterator.next())) continue;
                bl = true;
            }
        }
        finally {
            featureIterator.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Iterator<SimpleFeature> iterator = null;
        try {
            iterator = this.iterator();
            if (object == null) {
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (iterator.hasNext()) {
                    if (!object.equals(iterator.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    public final Set getOpenIterators() {
        return this.open;
    }

    @Override
    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        this.getOpenIterators().add(iterator);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            if (object == null) {
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    iterator.remove();
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (iterator.hasNext()) {
                    if (!object.equals(iterator.next())) continue;
                    iterator.remove();
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                FeatureCollection featureCollection = (FeatureCollection)((Object)collection);
                featureCollection.close(iterator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                FeatureCollection featureCollection = (FeatureCollection)((Object)collection);
                featureCollection.close(iterator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator<SimpleFeature> iterator = null;
        try {
            iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = iterator.next();
                ++n;
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            T[] TArray = objectArray;
            for (int i = 0; i < n; ++i) {
                TArray[i] = iterator.next();
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accepts(FeatureVisitor featureVisitor, ProgressListener progressListener) {
        Iterator<SimpleFeature> iterator = null;
        if (progressListener == null) {
            progressListener = new NullProgressListener();
        }
        try {
            float f = this.size();
            float f2 = 0.0f;
            progressListener.started();
            iterator = this.iterator();
            while (!progressListener.isCanceled() && iterator.hasNext()) {
                if (f > 0.0f) {
                    float f3 = f2;
                    f2 = f3 + 1.0f;
                    progressListener.progress(f3 / f);
                }
                try {
                    SimpleFeature simpleFeature = iterator.next();
                    featureVisitor.visit(simpleFeature);
                }
                catch (Exception exception) {
                    progressListener.exceptionOccurred(exception);
                }
            }
        }
        finally {
            progressListener.complete();
            this.close(iterator);
        }
    }

    public SimpleFeatureCollection subList(Filter filter) {
        return new SubFeatureList((SimpleFeatureCollection)this, filter);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public SimpleFeatureCollection sort(SortBy sortBy) {
        return new SubFeatureList((SimpleFeatureCollection)this, sortBy);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public abstract ReferencedEnvelope getBounds();
}

