/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureTypes {
    public static final URI DEFAULT_NAMESPACE;
    public static final SimpleFeatureType ABSTRACT_FEATURE_TYPE;

    public static SimpleFeatureType transform(SimpleFeatureType simpleFeatureType, CoordinateReferenceSystem coordinateReferenceSystem) throws SchemaException {
        return FeatureTypes.transform(simpleFeatureType, coordinateReferenceSystem, false);
    }

    public static SimpleFeatureType transform(SimpleFeatureType simpleFeatureType, CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws SchemaException {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(simpleFeatureType.getTypeName());
        simpleFeatureTypeBuilder.setNamespaceURI(simpleFeatureType.getName().getNamespaceURI());
        simpleFeatureTypeBuilder.setAbstract(simpleFeatureType.isAbstract());
        for (int i = 0; i < simpleFeatureType.getAttributeCount(); ++i) {
            AttributeDescriptor attributeDescriptor = simpleFeatureType.getDescriptor(i);
            if (attributeDescriptor instanceof GeometryDescriptor) {
                GeometryDescriptor geometryDescriptor = (GeometryDescriptor)attributeDescriptor;
                simpleFeatureTypeBuilder.descriptor(geometryDescriptor);
                if (!bl || geometryDescriptor.getCoordinateReferenceSystem() == null) {
                    simpleFeatureTypeBuilder.crs(coordinateReferenceSystem);
                }
                simpleFeatureTypeBuilder.add(geometryDescriptor.getLocalName(), geometryDescriptor.getType().getBinding());
                continue;
            }
            simpleFeatureTypeBuilder.add(attributeDescriptor);
        }
        if (simpleFeatureType.getGeometryDescriptor() != null) {
            simpleFeatureTypeBuilder.setDefaultGeometry(simpleFeatureType.getGeometryDescriptor().getLocalName());
        }
        simpleFeatureTypeBuilder.setSuperType((SimpleFeatureType)simpleFeatureType.getSuper());
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] attributeDescriptorArray, String string, URI uRI, boolean bl, SimpleFeatureType[] simpleFeatureTypeArray) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(attributeDescriptorArray, string, uRI, bl, simpleFeatureTypeArray, null);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] attributeDescriptorArray, String string, URI uRI, boolean bl, SimpleFeatureType[] simpleFeatureTypeArray, AttributeDescriptor attributeDescriptor) throws FactoryRegistryException, SchemaException {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(string);
        simpleFeatureTypeBuilder.setNamespaceURI(uRI);
        simpleFeatureTypeBuilder.setAbstract(bl);
        if (attributeDescriptorArray != null) {
            simpleFeatureTypeBuilder.addAll(attributeDescriptorArray);
        }
        if (attributeDescriptor != null) {
            boolean bl2 = true;
            for (int i = 0; i < attributeDescriptorArray.length; ++i) {
                if (attributeDescriptorArray[i] != attributeDescriptor) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                simpleFeatureTypeBuilder.add(attributeDescriptor);
            }
            simpleFeatureTypeBuilder.setDefaultGeometry(attributeDescriptor.getLocalName());
        }
        if (simpleFeatureTypeArray != null && simpleFeatureTypeArray.length > 0) {
            if (simpleFeatureTypeArray.length > 1) {
                throw new SchemaException("Can only specify a single super type");
            }
            simpleFeatureTypeBuilder.setSuperType(simpleFeatureTypeArray[0]);
        } else {
            simpleFeatureTypeBuilder.setSuperType(ABSTRACT_FEATURE_TYPE);
        }
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] attributeDescriptorArray, String string, URI uRI, boolean bl, SimpleFeatureType[] simpleFeatureTypeArray, GeometryDescriptor geometryDescriptor) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(attributeDescriptorArray, string, uRI, bl, simpleFeatureTypeArray, (AttributeDescriptor)geometryDescriptor);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] attributeDescriptorArray, String string, URI uRI, boolean bl) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(attributeDescriptorArray, string, uRI, bl, null);
    }

    public static List<FeatureType> getAncestors(FeatureType featureType) {
        ArrayList<FeatureType> arrayList = new ArrayList<FeatureType>();
        while (featureType.getSuper() instanceof FeatureType) {
            FeatureType featureType2 = (FeatureType)featureType.getSuper();
            arrayList.add(featureType2);
            featureType = featureType2;
        }
        return arrayList;
    }

    public static boolean equalsExact(SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2) {
        return FeatureTypes.equals(simpleFeatureType, simpleFeatureType2, true);
    }

    static boolean equals(SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2, boolean bl) {
        if (simpleFeatureType == simpleFeatureType2) {
            return true;
        }
        if (simpleFeatureType == null || simpleFeatureType2 == null) {
            return false;
        }
        if (bl && !FeatureTypes.equals(simpleFeatureType.getUserData(), simpleFeatureType2.getUserData())) {
            return false;
        }
        return FeatureTypes.equalsId(simpleFeatureType, simpleFeatureType2) && FeatureTypes.equals(simpleFeatureType.getAttributeDescriptors(), simpleFeatureType2.getAttributeDescriptors(), bl) && FeatureTypes.equalsAncestors(simpleFeatureType, simpleFeatureType2);
    }

    static boolean equals(List list, List list2, boolean bl) {
        return FeatureTypes.equals(list.toArray(new AttributeDescriptor[list.size()]), list2.toArray(new AttributeDescriptor[list2.size()]), bl);
    }

    static boolean equals(AttributeDescriptor[] attributeDescriptorArray, AttributeDescriptor[] attributeDescriptorArray2, boolean bl) {
        if (attributeDescriptorArray.length != attributeDescriptorArray2.length) {
            return false;
        }
        int n = attributeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            if (FeatureTypes.equals(attributeDescriptorArray[i], attributeDescriptorArray2[i], bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAncestors(SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2) {
        return ((Object)FeatureTypes.ancestors(simpleFeatureType)).equals(FeatureTypes.ancestors(simpleFeatureType2));
    }

    public static Set ancestors(SimpleFeatureType simpleFeatureType) {
        if (simpleFeatureType == null || FeatureTypes.getAncestors(simpleFeatureType).isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<FeatureType>(FeatureTypes.getAncestors(simpleFeatureType));
    }

    static boolean equals(AttributeDescriptor attributeDescriptor, AttributeDescriptor attributeDescriptor2, boolean bl) {
        if (attributeDescriptor == attributeDescriptor2) {
            return true;
        }
        if (attributeDescriptor == null) {
            return true;
        }
        if (!attributeDescriptor.equals(attributeDescriptor2)) {
            return false;
        }
        if (bl) {
            if (!FeatureTypes.equals(attributeDescriptor.getUserData(), attributeDescriptor2.getUserData())) {
                return false;
            }
            if (!FeatureTypes.equals(attributeDescriptor.getType().getUserData(), attributeDescriptor2.getType().getUserData())) {
                return false;
            }
        }
        return true;
    }

    static boolean equals(Map map, Map map2) {
        if (map == map2) {
            return true;
        }
        if (map == null || map2 == null) {
            return false;
        }
        return ((Object)map).equals(map2);
    }

    public static boolean equalsId(SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2) {
        if (simpleFeatureType == simpleFeatureType2) {
            return true;
        }
        if (simpleFeatureType == null || simpleFeatureType2 == null) {
            return false;
        }
        String string = simpleFeatureType.getTypeName();
        String string2 = simpleFeatureType2.getTypeName();
        if (string == null && string2 != null) {
            return false;
        }
        if (!string.equals(string2)) {
            return false;
        }
        String string3 = simpleFeatureType.getName().getNamespaceURI();
        String string4 = simpleFeatureType2.getName().getNamespaceURI();
        if (string3 == null && string4 == null) {
            return true;
        }
        if (string3 == null && string4 != null) {
            return false;
        }
        return string3.equals(string4);
    }

    static {
        Object object;
        try {
            object = new URI("http://www.opengis.net/gml");
        }
        catch (URISyntaxException uRISyntaxException) {
            object = null;
        }
        DEFAULT_NAMESPACE = object;
        object = null;
        try {
            object = FeatureTypes.newFeatureType(null, "Feature", new URI("http://www.opengis.net/gml"), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABSTRACT_FEATURE_TYPE = object;
    }
}

