/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.type.FeatureType;

public class FeatureReaderIterator<F extends Feature>
implements Iterator<F> {
    FeatureReader<? extends FeatureType, F> reader;

    public FeatureReaderIterator(FeatureReader<? extends FeatureType, F> featureReader) {
        this.reader = featureReader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (Exception exception) {
            this.close();
            return false;
        }
    }

    @Override
    public F next() {
        if (this.reader == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.reader.next();
        }
        catch (IOException iOException) {
            this.close();
            NoSuchElementException noSuchElementException = new NoSuchElementException("Could not obtain the next feature:" + iOException);
            noSuchElementException.initCause(iOException);
            throw noSuchElementException;
        }
        catch (IllegalAttributeException illegalAttributeException) {
            this.close();
            NoSuchElementException noSuchElementException = new NoSuchElementException("Could not create the next feature:" + illegalAttributeException);
            noSuchElementException.initCause(illegalAttributeException);
            throw noSuchElementException;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Modification of contents is not supported");
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
    }
}

