/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

public class FactoryCreator
extends FactoryRegistry {
    private static final Class[] HINTS_ARGUMENT = new Class[]{Hints.class};
    private final Map<Class<?>, List<Reference<?>>> cache = new HashMap();
    private final Set<Class<?>> underConstruction = new HashSet();

    public FactoryCreator(Class<?>[] classArray) {
        super(classArray);
    }

    public FactoryCreator(Collection<Class<?>> collection) {
        super(collection);
    }

    @Override
    final <T> List<Reference<T>> getCachedProviders(Class<T> clazz) {
        List<Reference<T>> list = this.cache.get(clazz);
        if (list == null) {
            list = new LinkedList();
            this.cache.put(clazz, list);
        }
        List<Reference<T>> list2 = list;
        return list2;
    }

    private <T> void cache(Class<T> clazz, T t) {
        this.getCachedProviders(clazz).add(new WeakReference<T>(t));
    }

    @Override
    public <T> T getServiceProvider(Class<T> clazz, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        try {
            return super.getServiceProvider(clazz, filter, hints, key);
        }
        catch (FactoryNotFoundException factoryNotFoundException) {
            Object object;
            Iterator<T> iterator;
            Class[] classArray;
            FactoryNotFoundException factoryNotFoundException2 = factoryNotFoundException;
            if (hints == null || key == null) {
                classArray = null;
            } else {
                iterator = hints.get(key);
                if (iterator == null) {
                    classArray = null;
                } else {
                    classArray = iterator instanceof Class[] ? (Class[])iterator : new Class[]{(Class)((Object)iterator)};
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        T t;
                        int n2;
                        object = classArray[i];
                        if (object == null || !clazz.isAssignableFrom((Class<?>)object) || Modifier.isAbstract(n2 = ((Class)object).getModifiers()) || (t = this.createSafe(clazz, (Class<?>)object, hints)) == null) continue;
                        if (this.isAcceptable(t, clazz, hints, filter)) {
                            this.cache(clazz, t);
                            return t;
                        }
                        FactoryCreator.dispose(t);
                    }
                }
            }
            iterator = this.getUnfilteredProviders(clazz);
            while (iterator.hasNext()) {
                T t = iterator.next();
                Class<?> clazz2 = t.getClass();
                if (classArray != null && !FactoryCreator.isTypeOf(classArray, clazz2) || filter != null && !filter.filter(t)) continue;
                try {
                    object = this.createSafe(clazz, clazz2, hints);
                }
                catch (FactoryNotFoundException factoryNotFoundException3) {
                    Logging.recoverableException(LOGGER, FactoryCreator.class, "getServiceProvider", factoryNotFoundException3);
                    continue;
                }
                catch (FactoryRegistryException factoryRegistryException) {
                    if (factoryRegistryException.getCause() instanceof NoSuchMethodException) continue;
                    throw factoryRegistryException;
                }
                if (object == null) continue;
                if (this.isAcceptable(object, clazz, hints, filter)) {
                    this.cache(clazz, object);
                    return (T)object;
                }
                FactoryCreator.dispose(object);
            }
            throw factoryNotFoundException2;
        }
    }

    private static boolean isTypeOf(Class<?>[] classArray, Class<?> clazz) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createSafe(Class<T> clazz, Class<?> clazz2, Hints hints) {
        if (!this.underConstruction.add(clazz2)) {
            return null;
        }
        try {
            T t = this.createServiceProvider(clazz, clazz2, hints);
            return t;
        }
        finally {
            if (!this.underConstruction.remove(clazz2)) {
                throw new AssertionError();
            }
        }
    }

    protected <T> T createServiceProvider(Class<T> clazz, Class<?> clazz2, Hints hints) throws FactoryRegistryException {
        Throwable throwable;
        block8: {
            try {
                try {
                    return clazz.cast(clazz2.getConstructor(HINTS_ARGUMENT).newInstance(hints));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throwable = noSuchMethodException;
                    try {
                        return clazz.cast(clazz2.getConstructor(null).newInstance(null));
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                throwable = instantiationException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getCause();
                if (!(throwable instanceof FactoryRegistryException)) break block8;
                throw (FactoryRegistryException)throwable;
            }
        }
        throw new FactoryRegistryException(Errors.format(23, clazz2), throwable);
    }

    private static void dispose(Object object) {
    }
}

