/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryComparator;
import org.geotools.factory.Hints;
import org.geotools.io.TableWriter;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.referencing.AuthorityFactory;

public class AbstractFactory
implements Factory,
RegisterableService {
    public static final int MINIMUM_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 50;
    public static final int MAXIMUM_PRIORITY = 100;
    protected final int priority;
    protected final Map<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
    private final Map<RenderingHints.Key, Object> unmodifiableHints = Collections.unmodifiableMap(this.hints);

    protected AbstractFactory() {
        this(50);
    }

    protected AbstractFactory(int n) {
        this.priority = n;
        if (n < 1 || n > 100) {
            throw new IllegalArgumentException(Errors.format(58, "priority", n));
        }
    }

    public int getPriority() {
        return this.priority;
    }

    protected boolean addImplementationHints(RenderingHints renderingHints) {
        boolean bl = false;
        if (renderingHints != null) {
            for (Map.Entry<Object, Object> entry : renderingHints.entrySet()) {
                Object object = entry.getKey();
                if (!(object instanceof RenderingHints.Key)) continue;
                Object object2 = entry.getValue();
                Object object3 = this.hints.put((RenderingHints.Key)object, object2);
                if (bl || Utilities.equals(object2, object3)) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.unmodifiableHints;
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        Iterator iterator = serviceRegistry.getServiceProviders(clazz, false);
        while (iterator.hasNext()) {
            AbstractFactory abstractFactory;
            AbstractFactory abstractFactory2;
            int n;
            Object t = iterator.next();
            if (t == this || !(t instanceof AbstractFactory)) continue;
            AbstractFactory abstractFactory3 = (AbstractFactory)t;
            int n2 = this.getPriority();
            if (n2 > (n = abstractFactory3.getPriority())) {
                abstractFactory2 = this;
                abstractFactory = abstractFactory3;
            } else {
                if (n2 >= n) continue;
                abstractFactory2 = abstractFactory3;
                abstractFactory = this;
            }
            serviceRegistry.setOrdering(clazz, abstractFactory2, abstractFactory);
        }
    }

    public void onDeregistration(ServiceRegistry serviceRegistry, Class clazz) {
    }

    public final int hashCode() {
        return this.getClass().hashCode() + 37 * this.priority;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractFactory abstractFactory = (AbstractFactory)object;
            if (this.priority == abstractFactory.priority) {
                HashSet<FactoryComparator> hashSet = new HashSet<FactoryComparator>();
                return new FactoryComparator(this, abstractFactory).compare(hashSet);
            }
        }
        return false;
    }

    public String toString() {
        String string = AbstractFactory.format(this);
        IdentityHashMap<Factory, String> identityHashMap = new IdentityHashMap<Factory, String>();
        identityHashMap.put(this, string);
        String string2 = AbstractFactory.format(this.getImplementationHints(), identityHashMap);
        return string + System.getProperty("line.separator", "\n") + string2;
    }

    static String toString(Map<?, ?> map) {
        return AbstractFactory.format(map, new IdentityHashMap<Factory, String>());
    }

    private static String format(Factory factory) {
        String string = Classes.getShortClassName(factory);
        if (factory instanceof AuthorityFactory) {
            string = string + "[\"" + ((AuthorityFactory)((Object)factory)).getAuthority().getTitle() + "\"]";
        }
        return string;
    }

    private static String format(Map<?, ?> map, Map<Factory, String> map2) {
        TableWriter tableWriter;
        try {
            tableWriter = new TableWriter(null, " ");
            AbstractFactory.format(tableWriter, map, "  ", map2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return ((Object)tableWriter).toString();
    }

    private static void format(Writer writer, Map<?, ?> map, String string, Map<Factory, String> map2) throws IOException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string2;
            Object obj = entry.getKey();
            String string3 = obj instanceof RenderingHints.Key ? Hints.nameOf((RenderingHints.Key)obj) : String.valueOf(obj);
            Object object = entry.getValue();
            writer.write(string);
            writer.write(string3);
            writer.write("\t= ");
            Factory factory = null;
            if (object instanceof Factory) {
                factory = (Factory)object;
                object = AbstractFactory.format(factory);
                string2 = map2.put(factory, string3);
                if (string2 != null) {
                    map2.put(factory, string2);
                    writer.write("(same as ");
                    writer.write(string2);
                    object = ")";
                    factory = null;
                }
            }
            writer.write(String.valueOf(object));
            writer.write(10);
            if (factory == null) continue;
            string2 = Utilities.spaces(string.length() + 2);
            AbstractFactory.format(writer, factory.getImplementationHints(), string2, map2);
        }
    }
}

