/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp.xml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.InputStream;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.shp.xml.IdInfo;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ShpXmlFileReader
implements FileReader {
    Document dom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShpXmlFileReader(ShpFiles shpFiles) throws JDOMException, IOException {
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        InputStream inputStream = shpFiles.getInputStream(ShpFileType.SHP_XML, this);
        try {
            this.dom = sAXBuilder.build(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public Metadata parse() {
        return this.parseMetadata(this.dom.getRootElement());
    }

    protected Metadata parseMetadata(Element element) {
        Metadata metadata = new Metadata();
        metadata.setIdinfo(this.parseIdInfo(element.getChild("idinfo")));
        return metadata;
    }

    protected IdInfo parseIdInfo(Element element) {
        IdInfo idInfo = new IdInfo();
        Element element2 = element.getChild("spdom").getChild("bounding");
        idInfo.setBounding(this.parseBounding(element2));
        Element element3 = element.getChild("spdom").getChild("lbounding");
        idInfo.setLbounding(this.parseBounding(element3));
        return idInfo;
    }

    protected Envelope parseBounding(Element element) {
        if (element == null) {
            return new Envelope();
        }
        double d = Double.parseDouble(element.getChildText("westbc"));
        double d2 = Double.parseDouble(element.getChildText("eastbc"));
        double d3 = Double.parseDouble(element.getChildText("southbc"));
        double d4 = Double.parseDouble(element.getChildText("northbc"));
        return new Envelope(d, d2, d3, d4);
    }
}

