/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.TimeZone;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.resources.NIOUtilities;

public class IndexedDbaseFileReader
extends DbaseFileReader {
    public void goTo(int n) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            long l = (long)this.header.getHeaderLength() + (long)this.header.getRecordLength() * (long)(n - 1);
            if (this.useMemoryMappedBuffer) {
                if (l < this.currentOffset || this.currentOffset + (long)this.buffer.limit() < l + (long)this.header.getRecordLength()) {
                    NIOUtilities.clean(this.buffer);
                    FileChannel fileChannel = (FileChannel)this.channel;
                    this.currentOffset = fileChannel.size() > l + Integer.MAX_VALUE ? l : fileChannel.size() - Integer.MAX_VALUE;
                    this.buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.currentOffset, Integer.MAX_VALUE);
                    this.buffer.position((int)(l - this.currentOffset));
                } else {
                    this.buffer.position((int)(l - this.currentOffset));
                }
            } else if (this.currentOffset <= l && this.currentOffset + (long)this.buffer.limit() >= l) {
                this.buffer.position((int)(l - this.currentOffset));
            } else {
                FileChannel fileChannel = (FileChannel)this.channel;
                fileChannel.position(l);
                this.currentOffset = l;
                this.buffer.limit(this.buffer.capacity());
                this.buffer.position(0);
                this.fill(this.buffer, fileChannel);
                this.buffer.position(0);
            }
        } else {
            throw new UnsupportedOperationException("Random access not enabled!");
        }
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles, boolean bl, Charset charset, TimeZone timeZone) throws IOException {
        super(shpFiles, bl, charset, timeZone);
    }
}

