/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

public class ShapefileDirectoryFactory
extends ShapefileDataStoreFactory {
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "Directory containing geospatial files", true);

    @Override
    public String getDisplayName() {
        return "Directory of spatial files (shapefiles)";
    }

    @Override
    public String getDescription() {
        return "Takes a directory of shapefiles and exposes it as a data store";
    }

    @Override
    public boolean canProcess(Map map) {
        if (super.canProcess(map)) {
            try {
                URL uRL = (URL)URLP.lookUp(map);
                File file = DataUtilities.urlToFile(uRL);
                return file != null && file.exists() && file.isDirectory();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }
}

