/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.resources.Classes;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReTypeFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    SimpleFeatureType featureType;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;
    boolean clone;

    public ReTypeFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader, SimpleFeatureType simpleFeatureType, boolean bl) {
        this.reader = featureReader;
        this.featureType = simpleFeatureType;
        this.clone = bl;
        this.types = this.typeAttributes(simpleFeatureType, featureReader.getFeatureType());
        this.builder = new SimpleFeatureBuilder(simpleFeatureType);
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2) {
        if (FeatureTypes.equalsExact(simpleFeatureType2, simpleFeatureType)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (simpleFeatureType.getAttributeCount() > simpleFeatureType2.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] attributeDescriptorArray = new AttributeDescriptor[simpleFeatureType.getAttributeCount()];
        for (int i = 0; i < simpleFeatureType.getAttributeCount(); ++i) {
            Class<?> clazz;
            AttributeDescriptor attributeDescriptor = simpleFeatureType.getDescriptor(i);
            String string = attributeDescriptor.getLocalName();
            attributeDescriptorArray[i] = attributeDescriptor;
            AttributeDescriptor attributeDescriptor2 = simpleFeatureType2.getDescriptor(string);
            Class<?> clazz2 = attributeDescriptor.getType().getBinding();
            if (clazz2.isAssignableFrom(clazz = attributeDescriptor2.getType().getBinding())) continue;
            throw new IllegalArgumentException("Unable to retype FeatureReader for " + string + " as " + Classes.getShortName(clazz) + " cannot be assigned to " + Classes.getShortName(clazz2));
        }
        return attributeDescriptorArray;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IOException("FeatureReader has been closed");
        }
        SimpleFeature simpleFeature = this.reader.next();
        String string = simpleFeature.getID();
        for (int i = 0; i < this.types.length; ++i) {
            String string2 = this.types[i].getLocalName();
            if (this.clone) {
                this.builder.add(DataUtilities.duplicate(simpleFeature.getAttribute(string2)));
                continue;
            }
            this.builder.add(simpleFeature.getAttribute(string2));
        }
        return this.builder.buildFeature(string);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.featureType = null;
            this.types = null;
        }
    }
}

