/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.FeatureReader;
import org.geotools.data.TransactionStateDiff;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

public class DiffFeatureReader<T extends FeatureType, F extends Feature>
implements FeatureReader<T, F> {
    FeatureReader<T, F> reader;
    Diff diff;
    F next = null;
    private Filter filter;
    private Set encounteredFids;
    private Iterator<F> addedIterator;
    private Iterator<F> modifiedIterator;
    private Iterator<Identifier> fids;
    private boolean fidFilter = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiffFeatureReader(FeatureReader<T, F> featureReader, Diff diff, Filter filter) {
        this.reader = featureReader;
        this.diff = diff;
        this.filter = filter;
        this.encounteredFids = new HashSet();
        if (filter instanceof Id) {
            this.fidFilter = true;
        }
        Diff diff2 = this.diff;
        synchronized (diff2) {
            this.addedIterator = this.diff.added.values().iterator();
            this.modifiedIterator = this.diff.modified2.values().iterator();
        }
    }

    @Override
    public T getFeatureType() {
        return this.reader.getFeatureType();
    }

    @Override
    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            F f = this.next;
            this.next = null;
            return f;
        }
        throw new NoSuchElementException("No more Feature exists");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        if (this.filter == Filter.EXCLUDE) {
            return false;
        }
        while (this.reader != null && this.reader.hasNext()) {
            F f;
            try {
                f = this.reader.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new DataSourceException("Could not aquire the next Feature", noSuchElementException);
            }
            catch (IllegalAttributeException illegalAttributeException) {
                throw new DataSourceException("Could not aquire the next Feature", illegalAttributeException);
            }
            String string = f.getIdentifier().getID();
            this.encounteredFids.add(string);
            if (this.diff.modified2.containsKey(string)) {
                Feature feature = (Feature)this.diff.modified2.get(string);
                if (feature == TransactionStateDiff.NULL || !this.filter.evaluate(feature)) continue;
                this.next = feature;
                return true;
            }
            this.next = f;
            return true;
        }
        this.queryDiff();
        return this.next != null;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.diff != null) {
            this.diff = null;
            this.addedIterator = null;
        }
    }

    protected void queryDiff() {
        if (this.fidFilter) {
            this.queryFidFilter();
        } else {
            this.queryAdded();
            this.queryModified();
        }
    }

    protected void queryAdded() {
        while (this.addedIterator.hasNext() && this.next == null) {
            this.next = (Feature)this.addedIterator.next();
            if (!this.encounteredFids.contains(this.next.getIdentifier().getID()) && this.filter.evaluate(this.next)) continue;
            this.next = null;
        }
    }

    protected void queryModified() {
        while (this.modifiedIterator.hasNext() && this.next == null) {
            this.next = (Feature)this.modifiedIterator.next();
            if (this.next != TransactionStateDiff.NULL && !this.encounteredFids.contains(this.next.getIdentifier().getID()) && this.filter.evaluate(this.next)) continue;
            this.next = null;
        }
    }

    protected void queryFidFilter() {
        Id id = (Id)this.filter;
        if (this.fids == null) {
            this.fids = id.getIdentifiers().iterator();
        }
        while (this.fids.hasNext() && this.next == null) {
            String string = ((Object)this.fids.next()).toString();
            if (this.encounteredFids.contains(string)) continue;
            this.next = (Feature)this.diff.modified2.get(string);
            if (this.next != null) continue;
            this.next = (Feature)this.diff.added.get(string);
        }
    }
}

