/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Relation;

public abstract class RelationFixer {
    private List<String> applicableTypes = new ArrayList<String>();

    public RelationFixer(String type) {
        this.applicableTypes.add(type);
    }

    public RelationFixer(String[] types) {
        for (String type : types) {
            this.applicableTypes.add(type);
        }
    }

    public boolean isFixerApplicable(Relation rel) {
        if (rel == null) {
            return false;
        }
        if (!rel.hasKey("type")) {
            return false;
        }
        String type = rel.get("type");
        for (String oktype : this.applicableTypes) {
            if (!oktype.equals(type)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isRelationGood(Relation var1);

    public abstract Command fixRelation(Relation var1);
}

