/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import relcontext.relationfix.MultipolygonFixer;

public class BoundaryFixer
extends MultipolygonFixer {
    public BoundaryFixer() {
        super(new String[]{"boundary", "multipolygon"});
    }

    public boolean isFixerApplicable(Relation rel) {
        return super.isFixerApplicable(rel) && "administrative".equals(rel.get("boundary"));
    }

    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType().equals((Object)OsmPrimitiveType.RELATION) && !"subarea".equals(m.getRole())) {
                return false;
            }
            if (m.getType().equals((Object)OsmPrimitiveType.NODE) && !"label".equals(m.getRole()) && !"admin_centre".equals(m.getRole())) {
                return false;
            }
            if (!m.getType().equals((Object)OsmPrimitiveType.WAY) || "outer".equals(m.getRole()) || "inner".equals(m.getRole())) continue;
            return false;
        }
        return true;
    }

    public Command fixRelation(Relation rel) {
        Relation r = rel;
        Relation rr = this.fixMultipolygonRoles(r);
        boolean fixed = false;
        if (rr != null) {
            fixed = true;
            r = rr;
        }
        if ((rr = this.fixBoundaryRoles(r)) != null) {
            fixed = true;
            r = rr;
        }
        return fixed ? new ChangeCommand((OsmPrimitive)rel, (OsmPrimitive)r) : null;
    }

    private Relation fixBoundaryRoles(Relation source) {
        Relation r = new Relation(source);
        boolean fixed = false;
        for (int i = 0; i < r.getMembersCount(); ++i) {
            Node n;
            RelationMember m = r.getMember(i);
            String role = null;
            if (m.isRelation()) {
                role = "subarea";
            } else if (m.isNode() && !(n = (Node)m.getMember()).isIncomplete()) {
                role = n.hasKey("place") ? "admin_centre" : "label";
            }
            if (role == null || role.equals(m.getRole())) continue;
            r.setMember(i, new RelationMember(role, m.getMember()));
            fixed = true;
        }
        return fixed ? r : null;
    }
}

