/*
 * Decompiled with CFR 0.152.
 */
package mappaint;

import java.awt.Color;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import mappaint.AreaElemStyle;
import mappaint.ElemStyle;
import mappaint.ElemStyles;
import mappaint.IconElemStyle;
import mappaint.LineElemStyle;
import mappaint.MapPaintPlugin;
import org.openstreetmap.josm.tools.ColorHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ElemStyleHandler
extends DefaultHandler {
    boolean inDoc = false;
    boolean inRule = false;
    boolean inCondition = false;
    boolean inElemStyle = false;
    boolean inLine = false;
    boolean inIcon = false;
    boolean inArea = false;
    ElemStyle curStyle;
    ElemStyles styles = new ElemStyles();
    String curKey;
    String curValue;
    int curWidth = 1;
    int curRealWidth = 0;
    int curMinZoom;
    ImageIcon curIcon;
    Color curColour;
    boolean curAnnotate;

    public void setElemStyles(ElemStyles styles) {
        this.styles = styles;
    }

    public void startDocument() {
        this.inDoc = true;
    }

    public void endDocument() {
        this.inDoc = false;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        block12: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                if (!this.inDoc) break block12;
                                if (!qName.equals("rule")) break block13;
                                this.inRule = true;
                                break block12;
                            }
                            if (!qName.equals("condition") || !this.inRule) break block14;
                            this.inCondition = true;
                            for (int count = 0; count < atts.getLength(); ++count) {
                                if (atts.getQName(count).equals("k")) {
                                    this.curKey = atts.getValue(count);
                                    continue;
                                }
                                if (!atts.getQName(count).equals("v")) continue;
                                this.curValue = atts.getValue(count);
                            }
                            break block12;
                        }
                        if (!qName.equals("line")) break block15;
                        this.inLine = true;
                        for (int count = 0; count < atts.getLength(); ++count) {
                            if (atts.getQName(count).equals("width")) {
                                this.curWidth = Integer.parseInt(atts.getValue(count));
                                continue;
                            }
                            if (atts.getQName(count).equals("colour")) {
                                this.curColour = ColorHelper.html2color((String)atts.getValue(count));
                                continue;
                            }
                            if (!atts.getQName(count).equals("realwidth")) continue;
                            this.curRealWidth = Integer.parseInt(atts.getValue(count));
                        }
                        break block12;
                    }
                    if (!qName.equals("zoom")) break block16;
                    this.curMinZoom = 0;
                    for (int count = 0; count < atts.getLength(); ++count) {
                        if (!atts.getQName(count).equals("min")) continue;
                        this.curMinZoom = Integer.parseInt(atts.getValue(count));
                    }
                    break block12;
                }
                if (!qName.equals("icon")) break block17;
                this.inIcon = true;
                for (int count = 0; count < atts.getLength(); ++count) {
                    if (atts.getQName(count).equals("src")) {
                        String imageFile = MapPaintPlugin.getStyleDir() + "icons/" + atts.getValue(count);
                        File f = new File(imageFile);
                        if (f.exists()) {
                            this.curIcon = new ImageIcon(imageFile);
                            continue;
                        }
                        try {
                            URL path = this.getClass().getResource("/standard/icons/" + atts.getValue(count));
                            this.curIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(path));
                        }
                        catch (Exception e) {
                            URL path = this.getClass().getResource("/standard/icons/amenity.png");
                            this.curIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(path));
                        }
                        continue;
                    }
                    if (!atts.getQName(count).equals("annotate")) continue;
                    this.curAnnotate = Boolean.parseBoolean(atts.getValue(count));
                }
                break block12;
            }
            if (!qName.equals("area")) break block12;
            this.inArea = true;
            for (int count = 0; count < atts.getLength(); ++count) {
                if (!atts.getQName(count).equals("colour")) continue;
                this.curColour = ColorHelper.html2color((String)atts.getValue(count));
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inRule && qName.equals("rule")) {
            this.inRule = false;
            this.styles.add(this.curKey, this.curValue, this.curStyle);
        } else if (this.inCondition && qName.equals("condition")) {
            this.inCondition = false;
        } else if (this.inLine && qName.equals("line")) {
            this.inLine = false;
            this.curStyle = new LineElemStyle(this.curWidth, this.curRealWidth, this.curColour, this.curMinZoom);
            this.curWidth = 1;
            this.curRealWidth = 0;
        } else if (this.inIcon && qName.equals("icon")) {
            this.inIcon = false;
            this.curStyle = new IconElemStyle(this.curIcon, this.curAnnotate, this.curMinZoom);
        } else if (this.inArea && qName.equals("area")) {
            this.inArea = false;
            this.curStyle = new AreaElemStyle(this.curColour, this.curMinZoom);
        }
    }

    public void characters(char[] ch, int start, int length) {
    }
}

