/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.openstreetmap.hot.sds.SdsApi;
import org.openstreetmap.hot.sds.SdsWriter;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerWritePostprocessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritePostprocessor
implements OsmServerWritePostprocessor {
    SeparateDataStorePlugin plugin;

    public WritePostprocessor(SeparateDataStorePlugin plugin) {
        this.plugin = plugin;
    }

    public void postprocessUploadedPrimitives(Collection<IPrimitive> primitives, ProgressMonitor progress) {
        StringWriter swriter = new StringWriter();
        SdsWriter sdsWriter = new SdsWriter(new PrintWriter(swriter));
        sdsWriter.header();
        boolean somethingWritten = false;
        for (IPrimitive p : primitives) {
            for (SeparateDataStorePlugin.QueueItem q : this.plugin.uploadQueue) {
                if (!q.primitive.equals(p) || q.sdsOnly) continue;
                sdsWriter.write(q.primitive, q.tags);
                somethingWritten = true;
                q.processed = true;
            }
        }
        for (SeparateDataStorePlugin.QueueItem q : this.plugin.uploadQueue) {
            if (!q.sdsOnly) continue;
            sdsWriter.write(q.primitive, q.tags);
            somethingWritten = true;
            q.processed = true;
        }
        if (somethingWritten) {
            sdsWriter.footer();
            SdsApi api = SdsApi.getSdsApi();
            System.out.println("sending message:\n" + swriter.toString());
            api.updateSds(swriter.toString(), progress);
        }
        for (IPrimitive p : primitives) {
            this.plugin.learn(p);
        }
        for (SeparateDataStorePlugin.QueueItem q : this.plugin.uploadQueue) {
            if (!q.sdsOnly) continue;
            q.primitive.setModified(false);
            this.plugin.learn(q.primitive);
        }
        this.plugin.clearQueue();
    }
}

