/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Constants;
import org.openstreetmap.josm.plugins.turnlanes.model.GenericCommand;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Turn;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lane {
    private final Road.End roadEnd;
    private final int index;
    private final Kind kind;
    private Set<Turn> turns;
    private double length = -1.0;

    static List<Lane> load(Road.End roadEnd) {
        ArrayList<Lane> result = new ArrayList<Lane>();
        int i = 0;
        for (double l : roadEnd.getLengths(Kind.EXTRA_LEFT)) {
            result.add(new Lane(roadEnd, --i, Kind.EXTRA_LEFT, l));
        }
        Collections.reverse(result);
        int regulars = Lane.getRegularCount(roadEnd.getWay(), roadEnd.getJunction().getNode());
        for (i = 1; i <= regulars; ++i) {
            result.add(new Lane(roadEnd, i));
        }
        i = 0;
        for (double l : roadEnd.getLengths(Kind.EXTRA_RIGHT)) {
            result.add(new Lane(roadEnd, ++i, Kind.EXTRA_RIGHT, l));
        }
        return result;
    }

    static List<Double> loadLengths(Relation r, String key, double lengthBound) {
        ArrayList<Double> result = new ArrayList<Double>();
        if (r != null && r.get(key) != null) {
            for (String s : Constants.SPLIT_PATTERN.split(r.get(key))) {
                Double length = Double.parseDouble(s.trim());
                if (!(length >= lengthBound)) continue;
                result.add(length);
            }
        }
        return result;
    }

    static int getRegularCount(Way w, Node end) {
        int count = Utils.parseIntTag((OsmPrimitive)w, "lanes");
        boolean forward = w.lastNode().equals((Object)end);
        if (w.hasDirectionKeys()) {
            return Lane.getRegularCountOneWay(w, forward, count);
        }
        return Lane.getRegularCountTwoWay(w, forward, count);
    }

    private static int getRegularCountOneWay(Way w, boolean forward, int count) {
        if (forward ^ "-1".equals(w.get("oneway"))) {
            return count;
        }
        return 0;
    }

    private static int getRegularCountTwoWay(Way w, boolean forward, int count) {
        if (w.get("lanes:backward") != null) {
            int backwardCount = Utils.parseIntTag((OsmPrimitive)w, "lanes:backward");
            return forward ? count - backwardCount : backwardCount;
        }
        if (w.get("lanes:forward") != null) {
            int forwardCount = Utils.parseIntTag((OsmPrimitive)w, "lanes:forward");
            return forward ? forwardCount : count - forwardCount;
        }
        return forward ? (count + 1) / 2 : count / 2;
    }

    public Lane(Road.End roadEnd, int index) {
        this.roadEnd = roadEnd;
        this.index = index;
        this.kind = Kind.REGULAR;
    }

    public Lane(Road.End roadEnd, int index, Kind kind, double length) {
        assert (kind == Kind.EXTRA_LEFT || kind == Kind.EXTRA_RIGHT);
        this.roadEnd = roadEnd;
        this.index = index;
        this.kind = kind;
        this.length = length;
        if (length <= 0.0) {
            throw new IllegalArgumentException("Length must be positive");
        }
    }

    public Road getRoad() {
        return this.roadEnd.getRoad();
    }

    public Kind getKind() {
        return this.kind;
    }

    public double getLength() {
        return this.isExtra() ? this.length : this.getRoad().getLength();
    }

    public void setLength(double length) {
        if (!this.isExtra()) {
            throw new UnsupportedOperationException("Length can only be set for extra lanes.");
        }
        if (length <= 0.0) {
            throw new IllegalArgumentException("Length must positive.");
        }
        this.length = length;
        this.getOutgoingRoadEnd().updateLengths();
    }

    public boolean isExtra() {
        return this.getKind() != Kind.REGULAR;
    }

    public int getIndex() {
        return this.index;
    }

    public Junction getOutgoingJunction() {
        return this.getOutgoingRoadEnd().getJunction();
    }

    public Junction getIncomingJunction() {
        return this.getIncomingRoadEnd().getJunction();
    }

    public Road.End getOutgoingRoadEnd() {
        return this.roadEnd;
    }

    public Road.End getIncomingRoadEnd() {
        return this.roadEnd.getOppositeEnd();
    }

    public ModelContainer getContainer() {
        return this.getRoad().getContainer();
    }

    public void addTurn(List<Road> via, Road.End to) {
        Relation r;
        GenericCommand cmd = new GenericCommand(this.getOutgoingJunction().getNode().getDataSet(), I18n.tr((String)"Add turn", (Object[])new Object[0]));
        Relation existing = null;
        for (Turn t : to.getTurns()) {
            if (!t.getFrom().getOutgoingRoadEnd().equals(this.getOutgoingRoadEnd()) || !((Object)t.getVia()).equals(via)) continue;
            if (t.getFrom().equals(this)) {
                return;
            }
            existing = t.getRelation();
        }
        if (existing == null) {
            r = new Relation();
            r.put("type", "turnlanes:turns");
            r.addMember(new RelationMember("from", (OsmPrimitive)this.getOutgoingRoadEnd().getWay()));
            if (via.isEmpty()) {
                r.addMember(new RelationMember("via", (OsmPrimitive)this.getOutgoingJunction().getNode()));
            } else {
                for (Way w : Utils.flattenVia(this.getOutgoingJunction().getNode(), via, to.getJunction().getNode())) {
                    r.addMember(new RelationMember("via", (OsmPrimitive)w));
                }
            }
            r.addMember(new RelationMember("to", (OsmPrimitive)to.getWay()));
            cmd.add((OsmPrimitive)r);
        } else {
            r = existing;
        }
        String key = this.isExtra() ? "lanes:extra" : "lanes";
        List<Integer> lanes = Turn.indices(r, key);
        lanes.add(this.getIndex());
        cmd.backup((OsmPrimitive)r).put(key, Turn.join(lanes));
        Main.main.undoRedo.add((Command)cmd);
    }

    public Set<Turn> getTurns() {
        return this.turns;
    }

    public void remove() {
        if (!this.isExtra()) {
            throw new UnsupportedOperationException();
        }
        GenericCommand cmd = new GenericCommand(this.getOutgoingJunction().getNode().getDataSet(), I18n.tr((String)"Delete lane.", (Object[])new Object[0]));
        for (Turn t : this.getTurns()) {
            t.remove(cmd);
        }
        this.getOutgoingRoadEnd().removeLane(cmd, this);
        Main.main.undoRedo.add((Command)cmd);
    }

    void initialize() {
        Set<Turn> turns = Turn.load(this.getContainer(), "from", (OsmPrimitive)this.getOutgoingRoadEnd().getWay());
        Iterator<Turn> it = turns.iterator();
        while (it.hasNext()) {
            Turn t = it.next();
            if (t.getFrom().equals(this)) continue;
            it.remove();
        }
        this.turns = Collections.unmodifiableSet(turns);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        EXTRA_LEFT,
        EXTRA_RIGHT,
        REGULAR;


        public boolean isExtra() {
            return this == EXTRA_LEFT || this == EXTRA_RIGHT;
        }
    }
}

