/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;

public class ProcessingInstruction
extends Content {
    protected String rawData;
    protected Map mapData;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String string, String string2) {
        this.setTarget(string);
        this.setData(string2);
    }

    public ProcessingInstruction setTarget(String string) {
        String string2 = Verifier.checkProcessingInstructionTarget(string);
        if (string2 != null) {
            throw new IllegalTargetException(string, string2);
        }
        return this;
    }

    @Override
    public String getValue() {
        return this.rawData;
    }

    public ProcessingInstruction setData(String string) {
        String string2 = Verifier.checkProcessingInstructionData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, string2);
        }
        this.rawData = string;
        this.mapData = this.parseData(string);
        return this;
    }

    private Map parseData(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string.trim();
        while (!string2.trim().equals("")) {
            int n;
            String string3 = "";
            String string4 = "";
            int n2 = 0;
            char c = string2.charAt(n2);
            for (n = 1; n < string2.length(); ++n) {
                char c2 = string2.charAt(n);
                if (c2 == '=') {
                    string3 = string2.substring(n2, n).trim();
                    int[] nArray = ProcessingInstruction.extractQuotedString(string2.substring(n + 1));
                    if (nArray == null) {
                        return new HashMap();
                    }
                    string4 = string2.substring(nArray[0] + n + 1, nArray[1] + n + 1);
                    n += nArray[1] + 1;
                    break;
                }
                if (Character.isWhitespace(c) && !Character.isWhitespace(c2)) {
                    n2 = n;
                }
                c = c2;
            }
            string2 = string2.substring(n);
            if (string3.length() <= 0 || string4 == null) continue;
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private static int[] extractQuotedString(String string) {
        boolean bl = false;
        char c = '\"';
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 != '\"' && c2 != '\'') continue;
            if (!bl) {
                c = c2;
                bl = true;
                n = i + 1;
                continue;
            }
            if (c != c2) continue;
            bl = false;
            return new int[]{n, i};
        }
        return null;
    }

    @Override
    public Object clone() {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)super.clone();
        if (this.mapData != null) {
            processingInstruction.mapData = this.parseData(this.rawData);
        }
        return processingInstruction;
    }
}

