/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Factory;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.crs.DefaultVerticalCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultImageDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.datum.DefaultTemporalDatum;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.wkt.Parser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.CanonicalSet;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;

public class ReferencingObjectFactory
extends ReferencingFactory
implements CSFactory,
DatumFactory,
CRSFactory,
BufferedFactory {
    private MathTransformFactory mtFactory;
    private Parser parser;
    private final CanonicalSet<IdentifiedObject> pool = CanonicalSet.newInstance(IdentifiedObject.class);

    public ReferencingObjectFactory() {
        this(null);
    }

    public ReferencingObjectFactory(Hints hints) {
        if (hints != null && !hints.isEmpty()) {
            this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(hints);
            DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(hints);
            this.createParser(datumFactory, this.mtFactory);
            this.addHints(datumFactory);
            this.addHints(this.mtFactory);
        }
    }

    private void addHints(Object object) {
        if (object instanceof Factory) {
            this.hints.putAll(((Factory)object).getImplementationHints());
        }
    }

    private synchronized MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        }
        return this.mtFactory;
    }

    @Override
    public Ellipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createEllipsoid(map, d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoid = this.pool.unique(ellipsoid);
        return ellipsoid;
    }

    @Override
    public Ellipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createFlattenedSphere(map, d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoid = this.pool.unique(ellipsoid);
        return ellipsoid;
    }

    @Override
    public PrimeMeridian createPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) throws FactoryException {
        PrimeMeridian primeMeridian;
        try {
            primeMeridian = new DefaultPrimeMeridian(map, d, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        primeMeridian = this.pool.unique(primeMeridian);
        return primeMeridian;
    }

    @Override
    public GeodeticDatum createGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        GeodeticDatum geodeticDatum;
        try {
            geodeticDatum = new DefaultGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geodeticDatum = this.pool.unique(geodeticDatum);
        return geodeticDatum;
    }

    @Override
    public VerticalDatum createVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) throws FactoryException {
        VerticalDatum verticalDatum;
        try {
            verticalDatum = new DefaultVerticalDatum(map, verticalDatumType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        verticalDatum = this.pool.unique(verticalDatum);
        return verticalDatum;
    }

    @Override
    public TemporalDatum createTemporalDatum(Map<String, ?> map, Date date) throws FactoryException {
        TemporalDatum temporalDatum;
        try {
            temporalDatum = new DefaultTemporalDatum(map, date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        temporalDatum = this.pool.unique(temporalDatum);
        return temporalDatum;
    }

    @Override
    public EngineeringDatum createEngineeringDatum(Map<String, ?> map) throws FactoryException {
        EngineeringDatum engineeringDatum;
        try {
            engineeringDatum = new DefaultEngineeringDatum(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        engineeringDatum = this.pool.unique(engineeringDatum);
        return engineeringDatum;
    }

    @Override
    public ImageDatum createImageDatum(Map<String, ?> map, PixelInCell pixelInCell) throws FactoryException {
        ImageDatum imageDatum;
        try {
            imageDatum = new DefaultImageDatum(map, pixelInCell);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        imageDatum = this.pool.unique(imageDatum);
        return imageDatum;
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) throws FactoryException {
        CoordinateSystemAxis coordinateSystemAxis;
        try {
            coordinateSystemAxis = new DefaultCoordinateSystemAxis(map, string, axisDirection, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        coordinateSystemAxis = this.pool.unique(coordinateSystemAxis);
        return coordinateSystemAxis;
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        CartesianCS cartesianCS;
        try {
            cartesianCS = new DefaultCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        cartesianCS = this.pool.unique(cartesianCS);
        return cartesianCS;
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        CartesianCS cartesianCS;
        try {
            cartesianCS = new DefaultCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        cartesianCS = this.pool.unique(cartesianCS);
        return cartesianCS;
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        EllipsoidalCS ellipsoidalCS;
        try {
            ellipsoidalCS = new DefaultEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoidalCS = this.pool.unique(ellipsoidalCS);
        return ellipsoidalCS;
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        EllipsoidalCS ellipsoidalCS;
        try {
            ellipsoidalCS = new DefaultEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        ellipsoidalCS = this.pool.unique(ellipsoidalCS);
        return ellipsoidalCS;
    }

    @Override
    public VerticalCS createVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        VerticalCS verticalCS;
        try {
            verticalCS = new DefaultVerticalCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        verticalCS = this.pool.unique(verticalCS);
        return verticalCS;
    }

    @Override
    public CompoundCRS createCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem[] coordinateReferenceSystemArray) throws FactoryException {
        CompoundCRS compoundCRS;
        try {
            compoundCRS = new DefaultCompoundCRS(map, coordinateReferenceSystemArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        compoundCRS = this.pool.unique(compoundCRS);
        return compoundCRS;
    }

    @Override
    public EngineeringCRS createEngineeringCRS(Map<String, ?> map, EngineeringDatum engineeringDatum, CoordinateSystem coordinateSystem) throws FactoryException {
        EngineeringCRS engineeringCRS;
        try {
            engineeringCRS = new DefaultEngineeringCRS(map, engineeringDatum, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        engineeringCRS = this.pool.unique(engineeringCRS);
        return engineeringCRS;
    }

    @Override
    public VerticalCRS createVerticalCRS(Map<String, ?> map, VerticalDatum verticalDatum, VerticalCS verticalCS) throws FactoryException {
        VerticalCRS verticalCRS;
        try {
            verticalCRS = new DefaultVerticalCRS(map, verticalDatum, verticalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        verticalCRS = this.pool.unique(verticalCRS);
        return verticalCRS;
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CartesianCS cartesianCS) throws FactoryException {
        GeocentricCRS geocentricCRS;
        try {
            geocentricCRS = new DefaultGeocentricCRS(map, geodeticDatum, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geocentricCRS = this.pool.unique(geocentricCRS);
        return geocentricCRS;
    }

    @Override
    public GeographicCRS createGeographicCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) throws FactoryException {
        GeographicCRS geographicCRS;
        try {
            geographicCRS = new DefaultGeographicCRS(map, geodeticDatum, ellipsoidalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        geographicCRS = this.pool.unique(geographicCRS);
        return geographicCRS;
    }

    @Override
    public DerivedCRS createDerivedCRS(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, Conversion conversion, CoordinateSystem coordinateSystem) throws FactoryException {
        Object object;
        MathTransform mathTransform = conversion.getMathTransform();
        if (mathTransform == null) {
            object = conversion.getParameterValues();
            MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
            mathTransform = mathTransformFactory.createParameterizedTransform((ParameterValueGroup)object);
        }
        try {
            object = new DefaultDerivedCRS(map, conversion, coordinateReferenceSystem, mathTransform, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        object = (DerivedCRS)this.pool.unique(object);
        return object;
    }

    @Override
    public ProjectedCRS createProjectedCRS(Map<String, ?> map, GeographicCRS geographicCRS, Conversion conversion, CartesianCS cartesianCS) throws FactoryException {
        Object object;
        MathTransform mathTransform;
        MathTransform mathTransform2 = conversion.getMathTransform();
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransform2 != null && mathTransformFactory instanceof DefaultMathTransformFactory) {
            mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createBaseToDerived((CoordinateReferenceSystem)geographicCRS, mathTransform2, (CoordinateSystem)cartesianCS);
        } else {
            object = conversion.getParameterValues();
            mathTransform = mathTransformFactory.createBaseToDerived(geographicCRS, (ParameterValueGroup)object, cartesianCS);
            OperationMethod operationMethod = conversion.getMethod();
            if (!(operationMethod instanceof MathTransformProvider) && !map.containsKey("conversionType") && (operationMethod = mathTransformFactory.getLastMethodUsed()) instanceof MathTransformProvider) {
                HashMap hashMap = new HashMap(map);
                hashMap.put("conversionType", ((MathTransformProvider)operationMethod).getOperationType());
                map = hashMap;
            }
            if (mathTransform2 != null && mathTransform2.equals(mathTransform)) {
                mathTransform = mathTransform2;
            }
        }
        try {
            object = new DefaultProjectedCRS(map, conversion, geographicCRS, mathTransform, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        object = (ProjectedCRS)this.pool.unique(object);
        return object;
    }

    @Override
    public synchronized CoordinateReferenceSystem createFromWKT(String string) throws FactoryException {
        if (this.parser == null) {
            this.createParser(ReferencingFactoryFinder.getDatumFactory(null), this.getMathTransformFactory());
        }
        try {
            return this.parser.parseCoordinateReferenceSystem(string);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException(parseException);
        }
    }

    private void createParser(DatumFactory datumFactory, MathTransformFactory mathTransformFactory) {
        this.parser = new Parser(Symbols.DEFAULT, datumFactory, this, this, mathTransformFactory);
    }
}

