/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.geotools.io.ExpandedTabWriter;
import org.geotools.resources.XArray;
import org.geotools.util.Utilities;

public class TableWriter
extends FilterWriter {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 1;
    private static final char[][] BOX = new char[][]{{'\u250c', '\u252c', '\u2510', '\u251c', '\u253c', '\u2524', '\u2514', '\u2534', '\u2518', '\u2500', '\u2502'}, {'\u2553', '\u2565', '\u2556', '\u255f', '\u256b', '\u2562', '\u2559', '\u2568', '\u255c', '\u2500', '\u2551'}, {'\u2552', '\u2564', '\u2555', '\u255e', '\u256a', '\u2561', '\u2558', '\u2567', '\u255b', '\u2550', '\u2502'}, {'\u2554', '\u2566', '\u2557', '\u2560', '\u256c', '\u2563', '\u255a', '\u2569', '\u255d', '\u2550', '\u2551'}, {'+', '+', '+', '+', '+', '+', '+', '+', '+', '-', '|'}};
    private static final char SPACE = ' ';
    private final StringBuilder buffer = new StringBuilder();
    private final List<Cell> cells = new ArrayList<Cell>();
    private int alignment = 0;
    private int column;
    private int row;
    private int[] width = new int[0];
    private final String separator;
    private final String leftBorder;
    private final String rightBorder;
    private boolean multiLinesCells;
    private final boolean stringOnly;
    private boolean skipCR;

    public TableWriter(Writer writer, int n) {
        this(writer, Utilities.spaces(n));
    }

    public TableWriter(Writer writer, String string) {
        super(writer != null ? writer : new StringWriter());
        int n;
        this.stringOnly = writer == null;
        int n2 = string.length();
        int n3 = n2;
        for (n = 0; n < n2 && Character.isSpaceChar(string.charAt(n)); ++n) {
        }
        while (n3 > 0 && Character.isSpaceChar(string.charAt(n3 - 1))) {
            --n3;
        }
        this.leftBorder = string.substring(n);
        this.rightBorder = string.substring(0, n3);
        this.separator = string;
    }

    private void writeBorder(Writer writer, int n, int n2, char c) throws IOException {
        String string;
        int n3 = 0;
        char[][] cArrayArray = new char[BOX.length][];
        for (int i = 0; i < BOX.length; ++i) {
            if (BOX[i][9] != c) continue;
            cArrayArray[n3++] = BOX[i];
        }
        switch (n) {
            case -1: {
                string = this.leftBorder;
                break;
            }
            case 1: {
                string = this.rightBorder;
                break;
            }
            case 0: {
                string = this.separator;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        if (n2 < -1 || n2 > 1) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        int n4 = n + 1 + (n2 + 1) * 3;
        int n5 = string.length();
        for (int i = 0; i < n5; ++i) {
            char c2 = string.charAt(i);
            if (Character.isSpaceChar(c2)) {
                c2 = c;
            } else {
                for (int j = 0; j < n3; ++j) {
                    if (cArrayArray[j][10] != c2) continue;
                    c2 = cArrayArray[j][n4];
                    break;
                }
            }
            writer.write(c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultiLinesCells(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.multiLinesCells = bl;
        }
    }

    public int getRowCount() {
        int n = this.row;
        if (this.column != 0) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.multiLinesCells) {
                switch (n) {
                    case 9: {
                        this.nextColumn();
                        this.skipCR = false;
                        return;
                    }
                    case 13: {
                        this.nextLine();
                        this.skipCR = true;
                        return;
                    }
                    case 10: {
                        if (!this.skipCR) {
                            this.nextLine();
                        }
                        this.skipCR = false;
                        return;
                    }
                }
            }
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            this.buffer.append((char)n);
            this.skipCR = false;
        }
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.skipCR && string.charAt(n) == '\n') {
                ++n;
                --n2;
            }
            if (!this.multiLinesCells) {
                int n3 = n;
                while (n2 != 0) {
                    switch (string.charAt(n3++)) {
                        case '\t': {
                            this.buffer.append(string.substring(n, n3 - 1));
                            this.nextColumn();
                            n = n3;
                            break;
                        }
                        case '\r': {
                            this.buffer.append(string.substring(n, n3 - 1));
                            this.nextLine();
                            if (n2 != 0 && string.charAt(n3) == '\n') {
                                --n2;
                            }
                            n = ++n3;
                            break;
                        }
                        case '\n': {
                            this.buffer.append(string.substring(n, n3 - 1));
                            this.nextLine();
                            n = n3;
                        }
                    }
                    --n2;
                }
                n2 = n3 - n;
            }
            this.skipCR = string.charAt(n + n2 - 1) == '\r';
            this.buffer.append(string.substring(n, n + n2));
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.skipCR && cArray[n] == '\n') {
                ++n;
                --n2;
            }
            if (!this.multiLinesCells) {
                int n3 = n;
                while (n2 != 0) {
                    switch (cArray[n3++]) {
                        case '\t': {
                            this.buffer.append(cArray, n, n3 - n - 1);
                            this.nextColumn();
                            n = n3;
                            break;
                        }
                        case '\r': {
                            this.buffer.append(cArray, n, n3 - n - 1);
                            this.nextLine();
                            if (n2 != 0 && cArray[n3] == '\n') {
                                --n2;
                            }
                            n = ++n3;
                            break;
                        }
                        case '\n': {
                            this.buffer.append(cArray, n, n3 - n - 1);
                            this.nextLine();
                            n = n3;
                        }
                    }
                    --n2;
                }
                n2 = n3 - n;
            }
            this.skipCR = cArray[n + n2 - 1] == '\r';
            this.buffer.append(cArray, n, n2);
        }
    }

    public void nextColumn() {
        this.nextColumn(' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextColumn(char c) {
        Object object = this.lock;
        synchronized (object) {
            String string = this.buffer.toString();
            this.cells.add(new Cell(string, this.alignment, c));
            if (this.column >= this.width.length) {
                this.width = XArray.resize(this.width, this.column + 1);
            }
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = stringTokenizer.nextToken().length();
                if (n2 <= n) continue;
                n = n2;
            }
            if (n > this.width[this.column]) {
                this.width[this.column] = n;
            }
            ++this.column;
            this.buffer.setLength(0);
        }
    }

    public void nextLine() {
        this.nextLine(' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextLine(char c) {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.length() != 0) {
                this.nextColumn(c);
            }
            assert (this.buffer.length() == 0);
            this.cells.add(!Character.isSpaceChar(c) ? new Cell(null, this.alignment, c) : null);
            this.column = 0;
            ++this.row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.length() != 0) {
                this.nextLine();
                assert (this.buffer.length() == 0);
            }
            this.flushTo(this.out);
            this.column = 0;
            this.row = 0;
            this.cells.clear();
            if (!(this.out instanceof TableWriter)) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.out.close();
        }
    }

    private void flushTo(Writer writer) throws IOException {
        String string = this.separator;
        String string2 = System.getProperty("line.separator", "\n");
        Object[] objectArray = new Cell[this.width.length];
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            Cell cell;
            Cell cell2 = null;
            int n2 = 0;
            while ((cell = this.cells.get(i)) != null) {
                if (cell.text == null) {
                    cell2 = new Cell("", cell.alignment, cell.fill);
                    break;
                }
                objectArray[n2++] = cell;
                if (++i < n) continue;
            }
            Arrays.fill(objectArray, n2, objectArray.length, cell2);
            while (!TableWriter.isEmpty(objectArray)) {
                for (int j = 0; j < objectArray.length; ++j) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    boolean bl = j == 0;
                    boolean bl2 = j + 1 == objectArray.length;
                    Object object = objectArray[j];
                    int n7 = this.width[j];
                    if (object == null) {
                        if (bl) {
                            writer.write(this.leftBorder);
                        }
                        TableWriter.repeat(writer, ' ', n7);
                        writer.write(bl2 ? this.rightBorder : string);
                        continue;
                    }
                    String string3 = ((Cell)object).toString();
                    int n8 = string3.indexOf(13);
                    int n9 = string3.indexOf(10);
                    int n10 = n8 < 0 ? n9 : (n6 = n9 < 0 ? n8 : Math.min(n8, n9));
                    if (n6 >= 0) {
                        n5 = n6 + 1;
                        if (n8 < 0 || n8 + 1 == n9) {
                            // empty if block
                        }
                        n4 = string3.length();
                        for (n3 = ++n5; n3 < n4 && Character.isWhitespace(string3.charAt(n3)); ++n3) {
                        }
                        objectArray[j] = n3 < n4 ? ((Cell)object).substring(n5) : null;
                        string3 = string3.substring(0, n6);
                    } else {
                        objectArray[j] = null;
                    }
                    n5 = string3.length();
                    if (n2 == 0) {
                        assert (n5 == 0);
                        n3 = i == 0 ? -1 : (i >= n - 1 ? 1 : 0);
                        if (bl) {
                            this.writeBorder(writer, -1, n3, ((Cell)object).fill);
                        }
                        TableWriter.repeat(writer, ((Cell)object).fill, n7);
                        this.writeBorder(writer, bl2 ? 1 : 0, n3, ((Cell)object).fill);
                        continue;
                    }
                    if (bl) {
                        writer.write(this.leftBorder);
                    }
                    Writer writer2 = string3.indexOf(9) >= 0 ? new ExpandedTabWriter(writer) : writer;
                    switch (((Cell)object).alignment) {
                        default: {
                            throw new AssertionError(((Cell)object).alignment);
                        }
                        case 0: {
                            writer2.write(string3);
                            TableWriter.repeat(writer2, ((Cell)object).fill, n7 - n5);
                            break;
                        }
                        case 2: {
                            TableWriter.repeat(writer2, ((Cell)object).fill, n7 - n5);
                            writer2.write(string3);
                            break;
                        }
                        case 1: {
                            n4 = (n7 - n5) / 2;
                            TableWriter.repeat(writer2, ((Cell)object).fill, n4);
                            writer2.write(string3);
                            TableWriter.repeat(writer2, ((Cell)object).fill, n7 - n4 - n5);
                            break;
                        }
                    }
                    writer.write(bl2 ? this.rightBorder : string);
                }
                writer.write(string2);
            }
        }
    }

    private static boolean isEmpty(Object[] objectArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            return false;
        }
        return true;
    }

    private static void repeat(Writer writer, char c, int n) throws IOException {
        while (--n >= 0) {
            writer.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            StringWriter stringWriter;
            int n = 2;
            for (int i = 0; i < this.width.length; ++i) {
                n += this.width[i];
            }
            n *= this.getRowCount();
            if (this.stringOnly) {
                stringWriter = (StringWriter)this.out;
                StringBuffer stringBuffer = stringWriter.getBuffer();
                stringBuffer.setLength(0);
                stringBuffer.ensureCapacity(n);
            } else {
                stringWriter = new StringWriter(n);
            }
            try {
                this.flushTo(stringWriter);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            return stringWriter.toString();
        }
    }

    private static final class Cell {
        public final String text;
        public int alignment;
        public final char fill;

        public Cell(String string, int n, char c) {
            this.text = string;
            this.alignment = n;
            this.fill = c;
        }

        public Cell substring(int n) {
            return new Cell(this.text.substring(n), this.alignment, this.fill);
        }

        public String toString() {
            return this.text;
        }
    }
}

