/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class TransactionStateDiff
implements Transaction.State {
    AbstractDataStore store;
    Transaction transaction;
    Map typeNameDiff = new HashMap();
    public static final SimpleFeature NULL = new SimpleFeature(){

        @Override
        public Object getAttribute(String string) {
            return null;
        }

        @Override
        public Object getAttribute(int n) {
            return null;
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return null;
        }

        public Geometry getDefaultGeometry() {
            return null;
        }

        @Override
        public SimpleFeatureType getFeatureType() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public FeatureId getIdentifier() {
            return null;
        }

        @Override
        public void setAttribute(int n, Object object) {
        }

        @Override
        public void setAttribute(String string, Object object) throws IllegalAttributeException {
        }

        @Override
        public Object getAttribute(Name name) {
            return null;
        }

        @Override
        public List<Object> getAttributes() {
            return null;
        }

        @Override
        public SimpleFeatureType getType() {
            return null;
        }

        @Override
        public void setAttribute(Name name, Object object) {
        }

        @Override
        public void setAttributes(List<Object> list) {
        }

        @Override
        public GeometryAttribute getDefaultGeometryProperty() {
            return null;
        }

        @Override
        public Collection<Property> getProperties() {
            return null;
        }

        @Override
        public Property getProperty(Name name) {
            return null;
        }

        @Override
        public Property getProperty(String string) {
            return null;
        }

        @Override
        public Collection<? extends Property> getValue() {
            return null;
        }

        @Override
        public AttributeDescriptor getDescriptor() {
            return null;
        }

        @Override
        public Name getName() {
            return null;
        }

        @Override
        public Map<Object, Object> getUserData() {
            return null;
        }

        @Override
        public boolean isNillable() {
            return false;
        }

        public String toString() {
            return "<NullFeature>";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        @Override
        public void validate() {
        }
    };

    public TransactionStateDiff(AbstractDataStore abstractDataStore) {
        this.store = abstractDataStore;
    }

    public synchronized Diff diff(String string) throws IOException {
        if (!this.exists(string)) {
            throw new IOException(string + " not defined");
        }
        if (this.typeNameDiff.containsKey(string)) {
            return (Diff)this.typeNameDiff.get(string);
        }
        Diff diff = new Diff();
        this.typeNameDiff.put(string, diff);
        return diff;
    }

    boolean exists(String string) {
        Object[] objectArray;
        try {
            objectArray = this.store.getTypeNames();
        }
        catch (IOException iOException) {
            return false;
        }
        Arrays.sort(objectArray);
        return Arrays.binarySearch(objectArray, string) != -1;
    }

    public synchronized FeatureWriter<SimpleFeatureType, SimpleFeature> writer(final String string, Filter filter) throws IOException {
        Diff diff = this.diff(string);
        FilteringFeatureReader<SimpleFeatureType, SimpleFeature> filteringFeatureReader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(this.store.getFeatureReader(string, new DefaultQuery(string, filter)), filter);
        return new DiffFeatureWriter(filteringFeatureReader, diff, filter){

            @Override
            public void fireNotification(int n, ReferencedEnvelope referencedEnvelope) {
                switch (n) {
                    case 1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(string, TransactionStateDiff.this.transaction, referencedEnvelope, false);
                        break;
                    }
                    case 0: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(string, TransactionStateDiff.this.transaction, referencedEnvelope, false);
                        break;
                    }
                    case -1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(string, TransactionStateDiff.this.transaction, referencedEnvelope, false);
                    }
                }
            }

            public String toString() {
                return "<DiffFeatureWriter>(" + this.reader.toString() + ")";
            }
        };
    }
}

