/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class ExtSSTRecord
extends StandardRecord {
    public static final short sid = 255;
    public static final int DEFAULT_BUCKET_SIZE = 8;
    public static final int MAX_BUCKETS = 128;
    private short _stringsPerBucket;
    private InfoSubRecord[] _sstInfos;

    public ExtSSTRecord() {
        this._stringsPerBucket = (short)8;
        this._sstInfos = new InfoSubRecord[0];
    }

    public ExtSSTRecord(RecordInputStream recordInputStream) {
        this._stringsPerBucket = recordInputStream.readShort();
        int n = recordInputStream.remaining() / 8;
        this._sstInfos = new InfoSubRecord[n];
        for (int i = 0; i < this._sstInfos.length; ++i) {
            this._sstInfos[i] = new InfoSubRecord(recordInputStream);
        }
    }

    public void setNumStringsPerBucket(short s) {
        this._stringsPerBucket = s;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTSST]\n");
        stringBuffer.append("    .dsst           = ").append(Integer.toHexString(this._stringsPerBucket)).append("\n");
        stringBuffer.append("    .numInfoRecords = ").append(this._sstInfos.length).append("\n");
        for (int i = 0; i < this._sstInfos.length; ++i) {
            stringBuffer.append("    .inforecord     = ").append(i).append("\n");
            stringBuffer.append("    .streampos      = ").append(Integer.toHexString(this._sstInfos[i].getStreamPos())).append("\n");
            stringBuffer.append("    .sstoffset      = ").append(Integer.toHexString(this._sstInfos[i].getBucketSSTOffset())).append("\n");
        }
        stringBuffer.append("[/EXTSST]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._stringsPerBucket);
        for (int i = 0; i < this._sstInfos.length; ++i) {
            this._sstInfos[i].serialize(littleEndianOutput);
        }
    }

    @Override
    protected int getDataSize() {
        return 2 + 8 * this._sstInfos.length;
    }

    public static final int getNumberOfInfoRecsForStrings(int n) {
        int n2 = n / 8;
        if (n % 8 != 0) {
            ++n2;
        }
        if (n2 > 128) {
            n2 = 128;
        }
        return n2;
    }

    @Override
    public short getSid() {
        return 255;
    }

    private static final class InfoSubRecord {
        public static final int ENCODED_SIZE = 8;
        private int field_1_stream_pos;
        private int field_2_bucket_sst_offset;
        private short field_3_zero;

        public InfoSubRecord(RecordInputStream recordInputStream) {
            this.field_1_stream_pos = recordInputStream.readInt();
            this.field_2_bucket_sst_offset = recordInputStream.readShort();
            this.field_3_zero = recordInputStream.readShort();
        }

        public int getStreamPos() {
            return this.field_1_stream_pos;
        }

        public int getBucketSSTOffset() {
            return this.field_2_bucket_sst_offset;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeInt(this.field_1_stream_pos);
            littleEndianOutput.writeShort(this.field_2_bucket_sst_offset);
            littleEndianOutput.writeShort(this.field_3_zero);
        }
    }
}

