/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ExponentialTransform1D;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

public class LogarithmicTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = 1535101265352133948L;
    private static final double EPS = 1.0E-8;
    public final double base;
    final double lnBase;
    public final double offset;
    private MathTransform1D inverse;

    private LogarithmicTransform1D(ExponentialTransform1D exponentialTransform1D) {
        this.base = exponentialTransform1D.base;
        this.lnBase = exponentialTransform1D.lnBase;
        this.offset = -Math.log(exponentialTransform1D.scale) / this.lnBase;
        this.inverse = exponentialTransform1D;
    }

    protected LogarithmicTransform1D(double d, double d2) {
        this.base = d;
        this.offset = d2;
        this.lnBase = Math.log(d);
    }

    static LogarithmicTransform1D create(ExponentialTransform1D exponentialTransform1D) {
        if (Math.abs(exponentialTransform1D.base - 10.0) < 1.0E-8) {
            return new Base10(exponentialTransform1D);
        }
        return new LogarithmicTransform1D(exponentialTransform1D);
    }

    public static MathTransform1D create(double d, double d2) {
        if (d == Double.POSITIVE_INFINITY || Math.abs(d) <= 1.0E-8) {
            return LinearTransform1D.create(0.0, d2);
        }
        if (Math.abs(d - 10.0) < 1.0E-8) {
            return new Base10(d2);
        }
        return new LogarithmicTransform1D(d, d2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), new ParameterValue[]{new FloatParameter(Provider.BASE, this.base), new FloatParameter(Provider.OFFSET, this.offset)});
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    @Override
    public double derivative(double d) {
        return 1.0 / (this.lnBase * d);
    }

    @Override
    public double transform(double d) {
        return Math.log(d) / this.lnBase + this.offset;
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(Math.log(fArray[n++]) / this.lnBase + this.offset);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(Math.log(fArray[n++]) / this.lnBase + this.offset);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = Math.log(dArray[n++]) / this.lnBase + this.offset;
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = Math.log(dArray[n++]) / this.lnBase + this.offset;
            }
        }
    }

    @Override
    MathTransform concatenate(MathTransform mathTransform, boolean bl) {
        if (mathTransform instanceof LinearTransform) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)mathTransform;
            if (bl) {
                if (linearTransform1D.offset == 0.0 && linearTransform1D.scale > 0.0) {
                    return LogarithmicTransform1D.create(this.base, Math.log(linearTransform1D.scale) / this.lnBase + this.offset);
                }
            } else {
                double d = Math.pow(this.base, 1.0 / linearTransform1D.scale);
                if (!Double.isNaN(d)) {
                    return LogarithmicTransform1D.create(d, linearTransform1D.scale * this.offset + linearTransform1D.offset);
                }
            }
        } else if (mathTransform instanceof ExponentialTransform1D) {
            return ((ExponentialTransform1D)mathTransform).concatenateLog(this, !bl);
        }
        return super.concatenate(mathTransform, bl);
    }

    @Override
    public int hashCode() {
        long l = 1535101265352133948L + Double.doubleToLongBits(this.base);
        l = l * 37L + Double.doubleToLongBits(this.offset);
        return (int)(l >>> 32) ^ (int)l;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LogarithmicTransform1D logarithmicTransform1D = (LogarithmicTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(logarithmicTransform1D.base) && Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(logarithmicTransform1D.offset);
        }
        return false;
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -7235097164208708484L;
        public static final ParameterDescriptor<Double> BASE = DefaultParameterDescriptor.create("base", 10.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE);
        public static final ParameterDescriptor<Double> OFFSET = DefaultParameterDescriptor.create("offset", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(130))}, new ParameterDescriptor[]{BASE, OFFSET});

        public Provider() {
            super(1, 1, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform1D createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            return LogarithmicTransform1D.create(Provider.doubleValue(BASE, parameterValueGroup), Provider.doubleValue(OFFSET, parameterValueGroup));
        }
    }

    private static final class Base10
    extends LogarithmicTransform1D {
        private static final long serialVersionUID = -5435804027536647558L;

        Base10(ExponentialTransform1D exponentialTransform1D) {
            super(exponentialTransform1D);
        }

        protected Base10(double d) {
            super(10.0, d);
        }

        @Override
        public double transform(double d) {
            return Math.log10(d) + this.offset;
        }

        @Override
        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
            if (fArray != fArray2 || n >= n2) {
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(Math.log10(fArray[n++]) + this.offset);
                }
            } else {
                n += n3;
                n2 += n3;
                while (--n3 >= 0) {
                    fArray2[--n2] = (float)(Math.log10(fArray[n++]) + this.offset);
                }
            }
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            if (dArray != dArray2 || n >= n2) {
                while (--n3 >= 0) {
                    dArray2[n2++] = Math.log10(dArray[n++]) + this.offset;
                }
            } else {
                n += n3;
                n2 += n3;
                while (--n3 >= 0) {
                    dArray2[--n2] = Math.log10(dArray[n++]) + this.offset;
                }
            }
        }
    }
}

