/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NameFactory;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.util.InternationalString;

public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    static final int COMPASS_DIRECTION_COUNT = 16;
    private static int PREDEFINED_COUNT = 0;
    private static final DefaultCoordinateSystemAxis[] PREDEFINED = new DefaultCoordinateSystemAxis[26];
    public static final DefaultCoordinateSystemAxis GEODETIC_LONGITUDE = new DefaultCoordinateSystemAxis(86, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis GEODETIC_LATITUDE = new DefaultCoordinateSystemAxis(85, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = new DefaultCoordinateSystemAxis(58, "h", AxisDirection.UP, SI.METER);
    public static final DefaultCoordinateSystemAxis ALTITUDE = new DefaultCoordinateSystemAxis(5, "h", AxisDirection.UP, SI.METER);
    public static final DefaultCoordinateSystemAxis DEPTH;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_RADIUS;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LONGITUDE;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LATITUDE;
    public static final DefaultCoordinateSystemAxis X;
    public static final DefaultCoordinateSystemAxis Y;
    public static final DefaultCoordinateSystemAxis Z;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_X;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Y;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Z;
    public static final DefaultCoordinateSystemAxis EASTING;
    public static final DefaultCoordinateSystemAxis WESTING;
    public static final DefaultCoordinateSystemAxis NORTHING;
    public static final DefaultCoordinateSystemAxis SOUTHING;
    public static final DefaultCoordinateSystemAxis TIME;
    public static final DefaultCoordinateSystemAxis COLUMN;
    public static final DefaultCoordinateSystemAxis ROW;
    private static final Map<String, CoordinateSystemAxis> ALIASES;
    private final String abbreviation;
    private final AxisDirection direction;
    private final Unit<?> unit;
    private final double minimum;
    private final double maximum;
    private final RangeMeaning rangeMeaning;
    private transient DefaultCoordinateSystemAxis opposite;

    private static boolean nameMatchesXY(String string, String string2) {
        if ((string = string.trim()).length() == 1) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis;
            switch (Character.toLowerCase(string.charAt(0))) {
                case 'x': {
                    defaultCoordinateSystemAxis = EASTING;
                    break;
                }
                case 'y': {
                    defaultCoordinateSystemAxis = NORTHING;
                    break;
                }
                default: {
                    return false;
                }
            }
            return defaultCoordinateSystemAxis.nameMatches(string2) || defaultCoordinateSystemAxis.getOpposite().nameMatches(string2);
        }
        return false;
    }

    public DefaultCoordinateSystemAxis(CoordinateSystemAxis coordinateSystemAxis) {
        super(coordinateSystemAxis);
        this.abbreviation = coordinateSystemAxis.getAbbreviation();
        this.direction = coordinateSystemAxis.getDirection();
        this.unit = coordinateSystemAxis.getUnit();
        this.minimum = coordinateSystemAxis.getMinimumValue();
        this.maximum = coordinateSystemAxis.getMaximumValue();
        this.rangeMeaning = coordinateSystemAxis.getRangeMeaning();
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit, double d, double d2, RangeMeaning rangeMeaning) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        this.minimum = d;
        this.maximum = d2;
        this.rangeMeaning = rangeMeaning;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", string);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", axisDirection);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        DefaultCoordinateSystemAxis.ensureNonNull("rangeMeaning", rangeMeaning);
        if (!(d < d2)) {
            throw new IllegalArgumentException(Errors.format(14, d, d2));
        }
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", string);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", axisDirection);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        if (unit.isCompatible(NonSI.DEGREE_ANGLE)) {
            UnitConverter unitConverter = NonSI.DEGREE_ANGLE.getConverterTo(unit);
            AxisDirection axisDirection2 = axisDirection.absolute();
            if (axisDirection2.equals(AxisDirection.NORTH)) {
                double d = Math.abs(unitConverter.convert(90.0));
                this.minimum = -d;
                this.maximum = d;
                this.rangeMeaning = RangeMeaning.EXACT;
                return;
            }
            if (axisDirection2.equals(AxisDirection.EAST)) {
                double d = Math.abs(unitConverter.convert(180.0));
                this.minimum = -d;
                this.maximum = d;
                this.rangeMeaning = RangeMeaning.WRAPAROUND;
                return;
            }
        }
        this.minimum = Double.NEGATIVE_INFINITY;
        this.maximum = Double.POSITIVE_INFINITY;
        this.rangeMeaning = RangeMeaning.EXACT;
    }

    public DefaultCoordinateSystemAxis(InternationalString internationalString, String string, AxisDirection axisDirection, Unit<?> unit) {
        this(DefaultCoordinateSystemAxis.toMap(internationalString), string, axisDirection, unit);
    }

    private static Map<String, Object> toMap(InternationalString internationalString) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        if (internationalString != null) {
            hashMap.put("name", internationalString.toString(null));
            hashMap.put("alias", NameFactory.create(new InternationalString[]{internationalString}));
        }
        return hashMap;
    }

    private DefaultCoordinateSystemAxis(int n, String string, AxisDirection axisDirection, Unit<?> unit) {
        this(n >= 0 ? Vocabulary.formatInternational(n) : new SimpleInternationalString(string), string, axisDirection, unit);
        DefaultCoordinateSystemAxis.PREDEFINED[DefaultCoordinateSystemAxis.PREDEFINED_COUNT++] = this;
    }

    public static DefaultCoordinateSystemAxis getPredefined(String string, AxisDirection axisDirection) {
        DefaultCoordinateSystemAxis.ensureNonNull("name", string);
        string = string.trim();
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = null;
        for (int i = 0; i < PREDEFINED_COUNT; ++i) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis2 = PREDEFINED[i];
            if (axisDirection != null && !axisDirection.equals(defaultCoordinateSystemAxis2.getDirection())) continue;
            if (defaultCoordinateSystemAxis2.abbreviation.equals(string)) {
                return defaultCoordinateSystemAxis2;
            }
            if (defaultCoordinateSystemAxis != null || !defaultCoordinateSystemAxis2.nameMatches(string) || (defaultCoordinateSystemAxis2 == GEODETIC_LONGITUDE || defaultCoordinateSystemAxis2 == GEODETIC_LATITUDE) && !string.toLowerCase().startsWith("geodetic")) continue;
            defaultCoordinateSystemAxis = defaultCoordinateSystemAxis2;
        }
        return defaultCoordinateSystemAxis;
    }

    static DefaultCoordinateSystemAxis getPredefined(CoordinateSystemAxis coordinateSystemAxis) {
        return DefaultCoordinateSystemAxis.getPredefined(coordinateSystemAxis.getName().getCode(), coordinateSystemAxis.getDirection());
    }

    @Override
    public AxisDirection getDirection() {
        return this.direction;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double getMinimumValue() {
        return this.minimum;
    }

    @Override
    public double getMaximumValue() {
        return this.maximum;
    }

    @Override
    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    final DefaultCoordinateSystemAxis getOpposite() {
        return this.opposite;
    }

    public static double getAngle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        DefaultCoordinateSystemAxis.ensureNonNull("source", axisDirection);
        DefaultCoordinateSystemAxis.ensureNonNull("target", axisDirection2);
        int n = DefaultCoordinateSystemAxis.getCompassAngle(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return (double)n * 22.5;
        }
        DirectionAlongMeridian directionAlongMeridian2 = DirectionAlongMeridian.parse(axisDirection);
        if (directionAlongMeridian2 != null && (directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection2)) != null) {
            return directionAlongMeridian2.getAngle(directionAlongMeridian);
        }
        return Double.NaN;
    }

    static int getCompassAngle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.NORTH.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 16 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 16) {
            if ((n = n3 - n) < -8) {
                n += 16;
            } else if (n > 8) {
                n -= 16;
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    final DefaultCoordinateSystemAxis usingUnit(Unit<?> unit) throws IllegalArgumentException {
        if (this.unit.equals(unit)) {
            return this;
        }
        if (this.unit.isCompatible(unit)) {
            return new DefaultCoordinateSystemAxis(DefaultCoordinateSystemAxis.getProperties(this, null), this.abbreviation, this.direction, unit, this.minimum, this.maximum, this.rangeMeaning);
        }
        throw new IllegalArgumentException(Errors.format(76, unit));
    }

    @Override
    public boolean nameMatches(String string) {
        if (super.nameMatches(string)) {
            return true;
        }
        CoordinateSystemAxis coordinateSystemAxis = ALIASES.get(string.trim().toLowerCase());
        return coordinateSystemAxis != null && coordinateSystemAxis == ALIASES.get(this.getName().getCode().trim().toLowerCase());
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            return this.equals((DefaultCoordinateSystemAxis)abstractIdentifiedObject, bl, true);
        }
        return false;
    }

    final boolean equals(DefaultCoordinateSystemAxis defaultCoordinateSystemAxis, boolean bl, boolean bl2) {
        if (bl) {
            if (!Utilities.equals(this.abbreviation, defaultCoordinateSystemAxis.abbreviation) || !Utilities.equals(this.rangeMeaning, defaultCoordinateSystemAxis.rangeMeaning) || Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(defaultCoordinateSystemAxis.minimum) || Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(defaultCoordinateSystemAxis.maximum)) {
                return false;
            }
        } else {
            String string;
            String string2 = defaultCoordinateSystemAxis.getName().getCode();
            if (!this.nameMatches(string2) && !DefaultCoordinateSystemAxis.nameMatches((IdentifiedObject)defaultCoordinateSystemAxis, string = this.getName().getCode())) {
                if (!bl2) {
                    return false;
                }
                if (!DefaultCoordinateSystemAxis.nameMatchesXY(string2, string) && !DefaultCoordinateSystemAxis.nameMatchesXY(string, string2)) {
                    return false;
                }
            }
        }
        return Utilities.equals(this.direction, defaultCoordinateSystemAxis.direction) && (!bl2 || Utilities.equals(this.unit, defaultCoordinateSystemAxis.unit));
    }

    @Override
    public int hashCode() {
        int n = 1684127127;
        n = n * 37 + this.abbreviation.hashCode();
        n = n * 37 + this.direction.hashCode();
        n = n * 37 + this.unit.hashCode();
        return n;
    }

    static {
        DefaultCoordinateSystemAxis.ALTITUDE.opposite = DEPTH = new DefaultCoordinateSystemAxis(44, "d", AxisDirection.DOWN, SI.METER);
        DefaultCoordinateSystemAxis.DEPTH.opposite = ALTITUDE;
        GEOCENTRIC_RADIUS = new DefaultCoordinateSystemAxis(78, "r", AxisDirection.UP, SI.METER);
        SPHERICAL_LONGITUDE = new DefaultCoordinateSystemAxis(206, "\u03a9", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        SPHERICAL_LATITUDE = new DefaultCoordinateSystemAxis(205, "\u03b8", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.EAST, SI.METER);
        Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.NORTH, SI.METER);
        Z = new DefaultCoordinateSystemAxis(-1, "z", AxisDirection.UP, SI.METER);
        GEOCENTRIC_X = new DefaultCoordinateSystemAxis(80, "X", AxisDirection.OTHER, SI.METER);
        GEOCENTRIC_Y = new DefaultCoordinateSystemAxis(81, "Y", AxisDirection.EAST, SI.METER);
        GEOCENTRIC_Z = new DefaultCoordinateSystemAxis(82, "Z", AxisDirection.NORTH, SI.METER);
        EASTING = new DefaultCoordinateSystemAxis(55, "E", AxisDirection.EAST, SI.METER);
        DefaultCoordinateSystemAxis.EASTING.opposite = WESTING = new DefaultCoordinateSystemAxis(244, "W", AxisDirection.WEST, SI.METER);
        DefaultCoordinateSystemAxis.WESTING.opposite = EASTING;
        NORTHING = new DefaultCoordinateSystemAxis(150, "N", AxisDirection.NORTH, SI.METER);
        DefaultCoordinateSystemAxis.NORTHING.opposite = SOUTHING = new DefaultCoordinateSystemAxis(203, "S", AxisDirection.SOUTH, SI.METER);
        DefaultCoordinateSystemAxis.SOUTHING.opposite = NORTHING;
        TIME = new DefaultCoordinateSystemAxis(218, "t", AxisDirection.FUTURE, NonSI.DAY);
        COLUMN = new DefaultCoordinateSystemAxis(25, "i", AxisDirection.COLUMN_POSITIVE, Unit.ONE);
        ROW = new DefaultCoordinateSystemAxis(187, "j", AxisDirection.ROW_POSITIVE, Unit.ONE);
        ALIASES = new HashMap<String, CoordinateSystemAxis>(12);
        ALIASES.put("lat", GEODETIC_LATITUDE);
        ALIASES.put("latitude", GEODETIC_LATITUDE);
        ALIASES.put("geodetic latitude", GEODETIC_LATITUDE);
        ALIASES.put("lon", GEODETIC_LONGITUDE);
        ALIASES.put("long", GEODETIC_LONGITUDE);
        ALIASES.put("longitude", GEODETIC_LONGITUDE);
        ALIASES.put("geodetic longitude", GEODETIC_LONGITUDE);
    }
}

