/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.FidFilter;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.identity.Identifier;

public class FidFilterImpl
extends AbstractFilterImpl
implements FidFilter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private Set fids = new HashSet();

    protected FidFilterImpl() {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)22;
    }

    protected FidFilterImpl(Set set) {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)22;
        for (Object e : set) {
            if (e instanceof Identifier) continue;
            throw new ClassCastException("Fids must implement Identifier, " + e.getClass() + " does not");
        }
        this.fids = set;
    }

    public Set getIDs() {
        return this.getFidsSet();
    }

    public Set getIdentifiers() {
        return this.fids;
    }

    public Set getFidsSet() {
        return this.fids();
    }

    private Set fids() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Identifier identifier : this.fids) {
            treeSet.add(((Object)identifier).toString());
        }
        return treeSet;
    }

    @Override
    public boolean evaluate(Object object) {
        if (object == null) {
            return false;
        }
        Set set = this.fids();
        Object object2 = CommonFactoryFinder.getFilterFactory(null).property("@id").evaluate(object);
        return object2 == null ? false : set.contains(object2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.fids.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return "[ " + stringBuffer.toString() + " ]";
    }

    @Override
    public Object accept(FilterVisitor filterVisitor, Object object) {
        return filterVisitor.visit(this, object);
    }

    public boolean equals(Object object) {
        LOGGER.finest("condition: " + object);
        if (object != null && object.getClass() == this.getClass()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("condition: " + ((FidFilterImpl)object).filterType);
            }
            if (((FidFilterImpl)object).filterType == 22) {
                return ((Object)this.fids).equals(((FidFilterImpl)object).fids);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fids).hashCode();
    }
}

