/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FilteringIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class FilteringSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureCollection delegate;
    Filter filter;

    public FilteringSimpleFeatureCollection(SimpleFeatureCollection simpleFeatureCollection, Filter filter) {
        super(simpleFeatureCollection);
        this.delegate = simpleFeatureCollection;
        this.filter = filter;
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        return new FilteringIterator<SimpleFeature>(this.delegate.iterator(), this.filter);
    }

    @Override
    public void close(Iterator<SimpleFeature> iterator) {
        FilteringIterator filteringIterator = (FilteringIterator)iterator;
        this.delegate.close(filteringIterator.getDelegate());
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int n = 0;
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.close(iterator);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] objectArray) {
        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Object[] objectArray2 = arrayList.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.close(iterator);
        }
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        if (!this.filter.evaluate(simpleFeature)) {
            return false;
        }
        return this.delegate.add(simpleFeature);
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object) && this.filter.evaluate(object);
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add((SimpleFeature)iterator.next());
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference(DataUtilities.bounds(this));
    }
}

