/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.MathTransformParser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;

public class Parser
extends MathTransformParser {
    private static final long serialVersionUID = -144097689843465085L;
    private static final boolean ALLOW_ORACLE_SYNTAX = true;
    private static Map<String, Class<?>> TYPES;
    protected final DatumFactory datumFactory;
    protected final CSFactory csFactory;
    protected final CRSFactory crsFactory;
    private final Map<String, AxisDirection> directions;

    public Parser() {
        this(Symbols.DEFAULT);
    }

    public Parser(Symbols symbols) {
        this(symbols, ReferencingFactoryFinder.getDatumFactory(null), ReferencingFactoryFinder.getCSFactory(null), ReferencingFactoryFinder.getCRSFactory(null), ReferencingFactoryFinder.getMathTransformFactory(null));
    }

    public Parser(Symbols symbols, ReferencingFactoryContainer referencingFactoryContainer) {
        this(symbols, referencingFactoryContainer.getDatumFactory(), referencingFactoryContainer.getCSFactory(), referencingFactoryContainer.getCRSFactory(), referencingFactoryContainer.getMathTransformFactory());
    }

    public Parser(Symbols symbols, DatumFactory datumFactory, CSFactory cSFactory, CRSFactory cRSFactory, MathTransformFactory mathTransformFactory) {
        super(symbols, mathTransformFactory);
        this.datumFactory = datumFactory;
        this.csFactory = cSFactory;
        this.crsFactory = cRSFactory;
        AxisDirection[] axisDirectionArray = AxisDirection.values();
        this.directions = new HashMap<String, AxisDirection>((int)Math.ceil((float)(axisDirectionArray.length + 1) / 0.75f), 0.75f);
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            this.directions.put(axisDirectionArray[i].name().trim().toUpperCase(), axisDirectionArray[i]);
        }
    }

    public CoordinateReferenceSystem parseCoordinateReferenceSystem(String string) throws ParseException {
        Element element = this.getTree(string, new ParsePosition(0));
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element);
        element.close();
        return coordinateReferenceSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element) throws ParseException {
        Object object = element.peek();
        if (object instanceof Element) {
            String string = ((Element)object).keyword.trim().toUpperCase(this.symbols.locale);
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            try {
                if ("GEOGCS".equals(string)) {
                    GeographicCRS geographicCRS = coordinateReferenceSystem = this.parseGeoGCS(element);
                    return geographicCRS;
                }
                if ("PROJCS".equals(string)) {
                    coordinateReferenceSystem = this.parseProjCS(element);
                    ProjectedCRS projectedCRS = coordinateReferenceSystem;
                    return projectedCRS;
                }
                if ("GEOCCS".equals(string)) {
                    coordinateReferenceSystem = this.parseGeoCCS(element);
                    GeocentricCRS geocentricCRS = coordinateReferenceSystem;
                    return geocentricCRS;
                }
                if ("VERT_CS".equals(string)) {
                    coordinateReferenceSystem = this.parseVertCS(element);
                    VerticalCRS verticalCRS = coordinateReferenceSystem;
                    return verticalCRS;
                }
                if ("LOCAL_CS".equals(string)) {
                    coordinateReferenceSystem = this.parseLocalCS(element);
                    EngineeringCRS engineeringCRS = coordinateReferenceSystem;
                    return engineeringCRS;
                }
                if ("COMPD_CS".equals(string)) {
                    coordinateReferenceSystem = this.parseCompdCS(element);
                    CompoundCRS compoundCRS = coordinateReferenceSystem;
                    return compoundCRS;
                }
                if ("FITTED_CS".equals(string)) {
                    coordinateReferenceSystem = this.parseFittedCS(element);
                    DerivedCRS derivedCRS = coordinateReferenceSystem;
                    return derivedCRS;
                }
            }
            finally {
                assert (Parser.isValid(coordinateReferenceSystem, string)) : element;
            }
        }
        throw element.parseFailed(null, Errors.format(187, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object parse(Element element) throws ParseException {
        Object object = element.peek();
        if (object instanceof Element) {
            String string = ((Element)object).keyword.trim().toUpperCase(this.symbols.locale);
            Object object2 = null;
            try {
                if ("AXIS".equals(string)) {
                    object2 = this.parseAxis(element, SI.METER, true);
                    CoordinateSystemAxis coordinateSystemAxis = object2;
                    return coordinateSystemAxis;
                }
                if ("PRIMEM".equals(string)) {
                    object2 = this.parsePrimem(element, NonSI.DEGREE_ANGLE);
                    PrimeMeridian primeMeridian = object2;
                    return primeMeridian;
                }
                if ("TOWGS84".equals(string)) {
                    object2 = Parser.parseToWGS84(element);
                    BursaWolfParameters bursaWolfParameters = object2;
                    return bursaWolfParameters;
                }
                if ("SPHEROID".equals(string)) {
                    object2 = this.parseSpheroid(element);
                    Ellipsoid ellipsoid = object2;
                    return ellipsoid;
                }
                if ("VERT_DATUM".equals(string)) {
                    object2 = this.parseVertDatum(element);
                    VerticalDatum verticalDatum = object2;
                    return verticalDatum;
                }
                if ("LOCAL_DATUM".equals(string)) {
                    object2 = this.parseLocalDatum(element);
                    EngineeringDatum engineeringDatum = object2;
                    return engineeringDatum;
                }
                if ("DATUM".equals(string)) {
                    object2 = this.parseDatum(element, DefaultPrimeMeridian.GREENWICH);
                    GeodeticDatum geodeticDatum = object2;
                    return geodeticDatum;
                }
                object2 = this.parseMathTransform(element, false);
                if (object2 != null) {
                    Object object3 = object2;
                    return object3;
                }
            }
            finally {
                assert (Parser.isValid(object2, string)) : element;
            }
        }
        return this.parseCoordinateReferenceSystem(element);
    }

    private static boolean isValid(Object object, String string) {
        if (object == null) {
            return true;
        }
        Class<?> clazz = Parser.getClassOf(string);
        return clazz != null && clazz.isInstance(object);
    }

    protected Map<String, Object> alterProperties(Map<String, Object> map) {
        return map;
    }

    private Map<String, Object> parseAuthority(Element element, String string) throws ParseException {
        Map<String, Object> map;
        boolean bl = element.isRoot();
        Element element2 = element.pullOptionalElement("AUTHORITY");
        if (element2 == null) {
            if (bl) {
                map = new HashMap<String, String>(4);
                map.put("name", string);
            } else {
                map = Collections.singletonMap("name", string);
            }
        } else {
            String string2 = element2.pullString("name");
            String string3 = element2.pullOptionalString("code");
            if (string3 == null) {
                int n = element2.pullInteger("code");
                string3 = String.valueOf(n);
            }
            element2.close();
            Citation citation = Citations.fromName(string2);
            map = new HashMap<String, Object>(4);
            map.put("name", new NamedIdentifier(citation, string));
            map.put("identifiers", new NamedIdentifier(citation, string3));
        }
        if (bl) {
            map = this.alterProperties(map);
        }
        return map;
    }

    private <T extends Quantity> Unit<T> parseUnit(Element element, Unit<T> unit) throws ParseException {
        Element element2 = element.pullElement("UNIT");
        String string = element2.pullString("name");
        double d = element2.pullDouble("factor");
        this.parseAuthority(element2, string);
        element2.close();
        return d != 1.0 ? unit.times(d) : unit;
    }

    private CoordinateSystemAxis parseAxis(Element element, Unit<?> unit, boolean bl) throws ParseException {
        Object object;
        AxisDirection axisDirection;
        Element element2;
        if (bl) {
            element2 = element.pullElement("AXIS");
        } else {
            element2 = element.pullOptionalElement("AXIS");
            if (element2 == null) {
                return null;
            }
        }
        String string = element2.pullString("name");
        Element element3 = element2.pullOptionalVoidElement();
        if (element3 != null) {
            axisDirection = this.directions.get(element3.keyword.trim().toUpperCase());
        } else {
            object = element2.pullString("orientation");
            axisDirection = DirectionAlongMeridian.parse((String)object).getDirection();
        }
        object = this.parseAuthority(element2, string);
        element2.close();
        if (axisDirection == null) {
            throw element2.parseFailed(null, Errors.format(187, element3));
        }
        try {
            return this.createAxis((Map<String, ?>)object, string, axisDirection, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private CoordinateSystemAxis createAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) throws FactoryException {
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.getPredefined(string, axisDirection);
        if (defaultCoordinateSystemAxis != null && unit.equals(defaultCoordinateSystemAxis.getUnit())) {
            return defaultCoordinateSystemAxis;
        }
        if (map == null) {
            map = Collections.singletonMap("name", string);
        }
        return this.csFactory.createCoordinateSystemAxis(map, string, axisDirection, unit);
    }

    private PrimeMeridian parsePrimem(Element element, Unit<Angle> unit) throws ParseException {
        Element element2 = element.pullElement("PRIMEM");
        String string = element2.pullString("name");
        double d = element2.pullDouble("longitude");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            return this.datumFactory.createPrimeMeridian(map, d, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private static BursaWolfParameters parseToWGS84(Element element) throws ParseException {
        Element element2 = element.pullOptionalElement("TOWGS84");
        if (element2 == null) {
            return null;
        }
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(DefaultGeodeticDatum.WGS84);
        bursaWolfParameters.dx = element2.pullDouble("dx");
        bursaWolfParameters.dy = element2.pullDouble("dy");
        bursaWolfParameters.dz = element2.pullDouble("dz");
        if (element2.peek() != null) {
            bursaWolfParameters.ex = element2.pullDouble("ex");
            bursaWolfParameters.ey = element2.pullDouble("ey");
            bursaWolfParameters.ez = element2.pullDouble("ez");
            bursaWolfParameters.ppm = element2.pullDouble("ppm");
        }
        element2.close();
        return bursaWolfParameters;
    }

    private Ellipsoid parseSpheroid(Element element) throws ParseException {
        Element element2 = element.pullElement("SPHEROID");
        String string = element2.pullString("name");
        double d = element2.pullDouble("semiMajorAxis");
        double d2 = element2.pullDouble("inverseFlattening");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        if (d2 == 0.0) {
            d2 = Double.POSITIVE_INFINITY;
        }
        try {
            return this.datumFactory.createFlattenedSphere(map, d, d2, SI.METER);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private ParameterValueGroup parseProjection(Element element, Ellipsoid ellipsoid, Unit<Length> unit, Unit<Angle> unit2) throws ParseException {
        ParameterValueGroup parameterValueGroup;
        Element element2 = element.pullElement("PROJECTION");
        String string = element2.pullString("name");
        this.parseAuthority(element2, string);
        element2.close();
        try {
            parameterValueGroup = this.mtFactory.getDefaultParameters(string);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw element2.parseFailed(noSuchIdentifierException, null);
        }
        Element element3 = element;
        try {
            Object object;
            if (ellipsoid != null) {
                object = ellipsoid.getAxisUnit();
                parameterValueGroup.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), (Unit<?>)object);
                parameterValueGroup.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), (Unit<?>)object);
            }
            while ((element3 = element.pullOptionalElement("PARAMETER")) != null) {
                object = element3.pullString("name");
                double d = element3.pullDouble("value");
                ParameterValue<Quantity> parameterValue = parameterValueGroup.parameter((String)object);
                Unit<?> unit3 = parameterValue.getDescriptor().getUnit();
                if (unit3 != null && !Unit.ONE.equals(unit3)) {
                    if (unit != null && SI.METER.isCompatible(unit3)) {
                        parameterValue.setValue(d, unit);
                        continue;
                    }
                    if (unit2 != null && SI.RADIAN.isCompatible(unit3)) {
                        parameterValue.setValue(d, unit2);
                        continue;
                    }
                }
                parameterValue.setValue(d);
            }
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            throw element3.parseFailed(parameterNotFoundException, Errors.format(176, parameterNotFoundException.getParameterName()));
        }
        return parameterValueGroup;
    }

    private GeodeticDatum parseDatum(Element element, PrimeMeridian primeMeridian) throws ParseException {
        Element element2 = element.pullElement("DATUM");
        String string = element2.pullString("name");
        Ellipsoid ellipsoid = this.parseSpheroid(element2);
        BursaWolfParameters bursaWolfParameters = Parser.parseToWGS84(element2);
        Map<String, Object> map = this.parseAuthority(element2, string);
        if (bursaWolfParameters == null && element2.peek() instanceof Number) {
            bursaWolfParameters = new BursaWolfParameters(DefaultGeodeticDatum.WGS84);
            bursaWolfParameters.dx = element2.pullDouble("dx");
            bursaWolfParameters.dy = element2.pullDouble("dy");
            bursaWolfParameters.dz = element2.pullDouble("dz");
            bursaWolfParameters.ex = element2.pullDouble("ex");
            bursaWolfParameters.ey = element2.pullDouble("ey");
            bursaWolfParameters.ez = element2.pullDouble("ez");
            bursaWolfParameters.ppm = element2.pullDouble("ppm");
        }
        element2.close();
        if (bursaWolfParameters != null) {
            if (!(map instanceof HashMap)) {
                map = new HashMap<String, Object>(map);
            }
            map.put("bursaWolf", bursaWolfParameters);
        }
        try {
            return this.datumFactory.createGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private VerticalDatum parseVertDatum(Element element) throws ParseException {
        Element element2 = element.pullElement("VERT_DATUM");
        String string = element2.pullString("name");
        int n = element2.pullInteger("datum");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        VerticalDatumType verticalDatumType = DefaultVerticalDatum.getVerticalDatumTypeFromLegacyCode(n);
        if (verticalDatumType == null) {
            throw element2.parseFailed(null, Errors.format(187, n));
        }
        try {
            return this.datumFactory.createVerticalDatum(map, verticalDatumType);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private EngineeringDatum parseLocalDatum(Element element) throws ParseException {
        Element element2 = element.pullElement("LOCAL_DATUM");
        String string = element2.pullString("name");
        element2.pullInteger("datum");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            return this.datumFactory.createEngineeringDatum(map);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private EngineeringCRS parseLocalCS(Element element) throws ParseException {
        Element element2 = element.pullElement("LOCAL_CS");
        String string = element2.pullString("name");
        EngineeringDatum engineeringDatum = this.parseLocalDatum(element2);
        Unit<Length> unit = this.parseUnit(element2, SI.METER);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, true);
        ArrayList<CoordinateSystemAxis> arrayList = new ArrayList<CoordinateSystemAxis>();
        do {
            arrayList.add(coordinateSystemAxis);
        } while ((coordinateSystemAxis = this.parseAxis(element2, unit, false)) != null);
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        AbstractCS abstractCS = new AbstractCS(Collections.singletonMap("name", string), arrayList.toArray(new CoordinateSystemAxis[arrayList.size()]));
        try {
            return this.crsFactory.createEngineeringCRS(map, engineeringDatum, abstractCS);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private GeocentricCRS parseGeoCCS(Element element) throws ParseException {
        Element element2 = element.pullElement("GEOCCS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        PrimeMeridian primeMeridian = this.parsePrimem(element2, NonSI.DEGREE_ANGLE);
        GeodeticDatum geodeticDatum = this.parseDatum(element2, primeMeridian);
        Unit<Length> unit = this.parseUnit(element2, SI.METER);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        try {
            CoordinateSystemAxis coordinateSystemAxis2;
            CoordinateSystemAxis coordinateSystemAxis3;
            if (coordinateSystemAxis != null) {
                coordinateSystemAxis3 = this.parseAxis(element2, unit, true);
                coordinateSystemAxis2 = this.parseAxis(element2, unit, true);
            } else {
                coordinateSystemAxis = this.createAxis(null, "X", AxisDirection.OTHER, unit);
                coordinateSystemAxis3 = this.createAxis(null, "Y", AxisDirection.EAST, unit);
                coordinateSystemAxis2 = this.createAxis(null, "Z", AxisDirection.NORTH, unit);
            }
            element2.close();
            return this.crsFactory.createGeocentricCRS(map, geodeticDatum, this.csFactory.createCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis3, coordinateSystemAxis2));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private VerticalCRS parseVertCS(Element element) throws ParseException {
        Element element2 = element.pullElement("VERT_CS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        VerticalDatum verticalDatum = this.parseVertDatum(element2);
        Unit<Length> unit = this.parseUnit(element2, SI.METER);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            if (coordinateSystemAxis == null) {
                coordinateSystemAxis = this.createAxis(null, "Z", AxisDirection.UP, unit);
            }
            return this.crsFactory.createVerticalCRS(map, verticalDatum, this.csFactory.createVerticalCS(Collections.singletonMap("name", string), coordinateSystemAxis));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private GeographicCRS parseGeoGCS(Element element) throws ParseException {
        Element element2 = element.pullElement("GEOGCS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        Unit<Angle> unit = this.parseUnit(element2, SI.RADIAN);
        PrimeMeridian primeMeridian = this.parsePrimem(element2, unit);
        GeodeticDatum geodeticDatum = this.parseDatum(element2, primeMeridian);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        CoordinateSystemAxis coordinateSystemAxis2 = null;
        try {
            CoordinateSystemAxis coordinateSystemAxis3;
            if (coordinateSystemAxis != null) {
                coordinateSystemAxis3 = this.parseAxis(element2, unit, true);
                if (coordinateSystemAxis3 != null) {
                    coordinateSystemAxis2 = this.parseAxis(element2, SI.METER, false);
                }
            } else {
                coordinateSystemAxis = this.createAxis(null, "Lon", AxisDirection.EAST, unit);
                coordinateSystemAxis3 = this.createAxis(null, "Lat", AxisDirection.NORTH, unit);
            }
            element2.close();
            EllipsoidalCS ellipsoidalCS = coordinateSystemAxis2 != null ? this.csFactory.createEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis3, coordinateSystemAxis2) : this.csFactory.createEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis3);
            return this.crsFactory.createGeographicCRS(map, geodeticDatum, ellipsoidalCS);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private ProjectedCRS parseProjCS(Element element) throws ParseException {
        Element element2 = element.pullElement("PROJCS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        GeographicCRS geographicCRS = this.parseGeoGCS(element2);
        Ellipsoid ellipsoid = geographicCRS.getDatum().getEllipsoid();
        Unit<Length> unit = this.parseUnit(element2, SI.METER);
        Unit<Angle> unit2 = geographicCRS.getCoordinateSystem().getAxis(0).getUnit().asType(Angle.class);
        ParameterValueGroup parameterValueGroup = this.parseProjection(element2, ellipsoid, unit, unit2);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        try {
            CoordinateSystemAxis coordinateSystemAxis2;
            if (coordinateSystemAxis != null) {
                coordinateSystemAxis2 = this.parseAxis(element2, unit, true);
            } else {
                coordinateSystemAxis = this.createAxis(null, "X", AxisDirection.EAST, unit);
                coordinateSystemAxis2 = this.createAxis(null, "Y", AxisDirection.NORTH, unit);
            }
            element2.close();
            DefiningConversion definingConversion = new DefiningConversion(string, parameterValueGroup);
            return this.crsFactory.createProjectedCRS(map, geographicCRS, definingConversion, this.csFactory.createCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private CompoundCRS parseCompdCS(Element element) throws ParseException {
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[2];
        Element element2 = element.pullElement("COMPD_CS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        coordinateReferenceSystemArray[0] = this.parseCoordinateReferenceSystem(element2);
        coordinateReferenceSystemArray[1] = this.parseCoordinateReferenceSystem(element2);
        element2.close();
        try {
            return this.crsFactory.createCompoundCRS(map, coordinateReferenceSystemArray);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private DerivedCRS parseFittedCS(Element element) throws ParseException {
        Element element2 = element.pullElement("FITTED_CS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2);
        OperationMethod operationMethod = this.getOperationMethod();
        element2.close();
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[mathTransform.getSourceDimensions()];
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" axis ");
        int n = stringBuilder.length();
        try {
            Object object;
            for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
                object = String.valueOf(i);
                stringBuilder.setLength(n);
                stringBuilder.append((String)object);
                coordinateSystemAxisArray[i] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", stringBuilder.toString()), (String)object, AxisDirection.OTHER, Unit.ONE);
            }
            DefiningConversion definingConversion = new DefiningConversion(Collections.singletonMap("name", operationMethod.getName().getCode()), operationMethod, mathTransform.inverse());
            object = new AbstractCS(map, coordinateSystemAxisArray);
            return this.crsFactory.createDerivedCRS(map, coordinateReferenceSystem, definingConversion, (CoordinateSystem)object);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed(noninvertibleTransformException, null);
        }
    }

    public static Class<?> getClassOf(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim().toUpperCase(Locale.US);
        Class<?> clazz = Parser.getTypeMap().get(string);
        assert (clazz == null || clazz.equals(MathTransform.class) || string.equals(Parser.getNameOf(clazz))) : clazz;
        return clazz;
    }

    public static String getNameOf(Class<?> clazz) {
        if (clazz != null) {
            for (Map.Entry<String, Class<?>> entry : Parser.getTypeMap().entrySet()) {
                Class<?> clazz2 = entry.getValue();
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private static Map<String, Class<?>> getTypeMap() {
        if (TYPES == null) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(25);
            linkedHashMap.put("GEOGCS", GeographicCRS.class);
            linkedHashMap.put("PROJCS", ProjectedCRS.class);
            linkedHashMap.put("GEOCCS", GeocentricCRS.class);
            linkedHashMap.put("VERT_CS", VerticalCRS.class);
            linkedHashMap.put("LOCAL_CS", EngineeringCRS.class);
            linkedHashMap.put("COMPD_CS", CompoundCRS.class);
            linkedHashMap.put("FITTED_CS", DerivedCRS.class);
            linkedHashMap.put("AXIS", CoordinateSystemAxis.class);
            linkedHashMap.put("PRIMEM", PrimeMeridian.class);
            linkedHashMap.put("TOWGS84", BursaWolfParameters.class);
            linkedHashMap.put("SPHEROID", Ellipsoid.class);
            linkedHashMap.put("VERT_DATUM", VerticalDatum.class);
            linkedHashMap.put("LOCAL_DATUM", EngineeringDatum.class);
            linkedHashMap.put("DATUM", GeodeticDatum.class);
            linkedHashMap.put("PARAM_MT", MathTransform.class);
            linkedHashMap.put("CONCAT_MT", MathTransform.class);
            linkedHashMap.put("INVERSE_MT", MathTransform.class);
            linkedHashMap.put("PASSTHROUGH_MT", MathTransform.class);
            TYPES = linkedHashMap;
        }
        return TYPES;
    }
}

