/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.metadata.PropertyAccessor;
import org.geotools.util.Utilities;

final class PropertyMap
extends AbstractMap<String, Object> {
    private final Object metadata;
    private final PropertyAccessor accessor;
    private final Set<Map.Entry<String, Object>> entrySet;

    public PropertyMap(Object object, PropertyAccessor propertyAccessor) {
        this.metadata = object;
        this.accessor = propertyAccessor;
        this.entrySet = new Entries();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public Object get(Object object) {
        Object object2;
        if (object instanceof String && !PropertyAccessor.isEmpty(object2 = this.accessor.get(this.accessor.indexOf((String)object), this.metadata))) {
            return object2;
        }
        return null;
    }

    @Override
    public Object put(String string, Object object) throws IllegalArgumentException, ClassCastException {
        return this.accessor.set(this.accessor.requiredIndexOf(string), this.metadata, object);
    }

    @Override
    public Object remove(Object object) {
        if (object instanceof String) {
            return this.put((String)object, (Object)null);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entrySet;
    }

    private final class Entries
    extends AbstractSet<Map.Entry<String, Object>> {
        Entries() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return PropertyMap.this.accessor.count(PropertyMap.this.metadata, Integer.MAX_VALUE);
        }

        @Override
        public boolean isEmpty() {
            return PropertyMap.this.accessor.count(PropertyMap.this.metadata, 1) == 0;
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object k;
            if (object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) instanceof String) {
                return new Property((String)k).equals(entry);
            }
            return false;
        }
    }

    private final class Iter
    implements Iterator<Map.Entry<String, Object>> {
        private Property current;
        private Property next;

        Iter() {
            this.move(0);
        }

        private void move(int n) {
            int n2 = PropertyMap.this.accessor.count();
            while (n < n2) {
                if (!PropertyAccessor.isEmpty(PropertyMap.this.accessor.get(n, PropertyMap.this.metadata))) {
                    this.next = new Property(n);
                    return;
                }
                ++n;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<String, Object> next() {
            if (this.next != null) {
                this.current = this.next;
                this.move(this.next.index + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue((Object)null);
            this.current = null;
        }
    }

    private final class Property
    implements Map.Entry<String, Object> {
        final int index;

        Property(int n) {
            this.index = n;
        }

        Property(String string) {
            this.index = PropertyMap.this.accessor.indexOf(string);
        }

        @Override
        public String getKey() {
            return PropertyMap.this.accessor.name(this.index);
        }

        @Override
        public Object getValue() {
            Object object = PropertyMap.this.accessor.get(this.index, PropertyMap.this.metadata);
            return PropertyAccessor.isEmpty(object) ? null : object;
        }

        @Override
        public Object setValue(Object object) throws ClassCastException {
            return PropertyMap.this.accessor.set(this.index, PropertyMap.this.metadata, object);
        }

        public boolean equals(Map.Entry<?, ?> entry) {
            return Utilities.equals(this.getKey(), entry.getKey()) && Utilities.equals(this.getValue(), entry.getValue());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map.Entry && this.equals((Map.Entry)object);
        }

        @Override
        public int hashCode() {
            Object object = this.getKey();
            int n = object != null ? object.hashCode() : 0;
            object = this.getValue();
            if (object != null) {
                n ^= object.hashCode();
            }
            return n;
        }
    }
}

